/*
 * SOURCE FILE : BCDNumber.h
 *
 * A 4 byte unsigned BCD integer.
 *
 */

#ifndef BCDNumberIncluded
  
  #define BCDNumberIncluded
  
  #include "Types.h"
  
  class BCDNumber {
    
  public :
  
    enum {
      ByteCount = 4,          // Number of bytes used to store number.
    };

    /***********************/
    /* ADD TWO BCD NUMBERS */
    /***********************/
    // Pass first number in A.
    // Pass second number in B.
    // Pass pointer to result in result.
    // Pass carry flag in carry.
    // Remember numbers are BCD coded so 0x99999999 means 9 million,
    // 9 hundred and 99 thousand, 9 hundred and 99.
    // Returns carry flag. If this is set then overflow occurred.
    static bool Add( UInt32 numA, UInt32 numB, UInt32 *result, bool carry = false );
    
  };

#endif

/* END of BCDNumber.h */

