/*
 * SOURCE FILE : ArenaConst.h
 *
 * A few more constants associated with screen coordinates for gameplay arena.
 *
 */

#ifndef ArenaConstIncluded
  
  #define ArenaConstIncluded

  #include "GameObject.h"
  #include "GDConst.h"
  #include "Rectangle.h"
  
  // Pixel coordinates and dimensions.
  #define ARENA_MIN_X 8
  #define ARENA_WIDTH 384
  #define ARENA_MIN_Y 16
  #define ARENA_HEIGHT 272
  
  // Character coordinates and dimensions.
  #define ARENA_BORDER_X 0
  #define ARENA_BORDER_Y 1
  #define ARENA_BORDER_WIDTH 50
  #define ARENA_BORDER_HEIGHT 36

  // Rectangle defining boundaries of arena.
  extern Rectangle ArenaRectangle;
    
  // Start coordinates for player. NOT pixel coordinates.
  #define PLAYER_START_X GameObject::FromPixel( ( ARENA_MIN_X + ( ( ARENA_WIDTH - SPRITE_PIXEL_WIDTH ) >> 1 ) ) )
  #define PLAYER_START_Y GameObject::FromPixel( ( ARENA_MIN_Y + ( ( ARENA_HEIGHT - SPRITE_PIXEL_HEIGHT ) >> 1 ) ) )

#endif

/* END of ArenaConst.h */

