/*
 * SOURCE FILE : main.cpp
 *
 * Test program to see if a 485 communications link is working.
 * This is designed to run on the LPC11U24 which only has a single
 * serial port. This program uses pin 9 for TX and pin 10 for RX.
 * There is only one serial port on the LPC11U24 so you cannot use
 * the USB serial port to the development PC at the same time.
 *
 */
 
#include "mbed.h"

/****************/
/* MAIN PROGRAM */
/****************/
int main() {
    // Digital output connected to on-board LED1.
    DigitalOut myled(LED1);
    // Digital output used to enable the 485 transmitter
    // and simultaneously disable the received.
    DigitalOut txEnable( p11 );
    txEnable = 0;
    // Serial port on pins 9 (TX) and 10 (RX).
    Serial port485( p9, p10 );
    // Set baud rate and protocol.
    port485.baud( 38400 );
    port485.format( 8, Serial::None, 1 );
    // Message to send.
    char message[] = " ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    // Do following until power goes off.
    while( true ) {
        // Toggle state of LED.
        myled = ( myled ? 0 : 1 );
        // Turn on the transmitter and disable receiver.
        txEnable = 1;
        // Transmit a message.
        char *ptr = message;
        while( *ptr != 0 ) {
            if( port485.writeable() ) {
                port485.putc( *ptr++ );
            }
        }
        // Wait a bit to let last byte transmit.
        wait_us( 600 );
        // Turn off the transmitter and enable the receiver.
        txEnable = 0;
        // Wait 1 second.
        wait_us( 1000000 );
    }
}
