/*
 * SOURCE FILE : GameduinoTest.cpp
 *
 * Definition of class GameduinoTest.
 * Tests a Gameduino object.
 *
 */

#include "GameduinoTest.h"      // this module's prototypes
#include "mbed.h"               // mbed library
#include "sprite.h"             // sprite data

/***************/
/* CONSTRUCTOR */
/***************/
GameduinoTest::GameduinoTest() {
}

/**************/
/* DESTRUCTOR */
/**************/
GameduinoTest::~GameduinoTest() {
}

/*********************/
/* DO ANIMATION TEST */
/*********************/
// Pass pointer to Gameduino to use in gd.
void GameduinoTest::AnimationTest( Gameduino *gd ) {
    Int16 x = 0;
    Int8 dir = 1;
    for( UInt16 i = 0; i < 1000; ++i ) {
        gd->waitvblank();
        gd->sprite( 100, x, 100, 0, 0 );
        x += dir;
        if( x > 200 ) {
            dir = -1;
        }
        else if( x < 0 ) {
            dir = 1;
        }
    }
}

/*********************/
/* TEST PLOTS METHOD */
/*********************/
// Pass pointer to Gameduino to use in gd.
void GameduinoTest::TestPlots( Gameduino *gd ) {
    #define PLOTLEN 3
    Gameduino::sprplot records[ PLOTLEN ] = {
        { 0, 0, 26, 0 },
        { 16, 1, 27, 0 },
        { 32, 2, 28, 0 },
    };
    gd->__wstartspr( 110 );
    gd->plots( 170, 0, records, PLOTLEN );
    gd->__end();
}

/****************/
/* RUN THE TEST */
/****************/
void GameduinoTest::Run( void ) {
    // Make a serial port for communicating with PC.
    Serial pc( USBTX, USBRX );
    // Sign on message.
    pc.printf( "Up and running!\r\n" );
    // Make a digital output for use with Gameduino.
    DigitalOut cs( p8 );
    // Initialise an SPI link for communications with Gameduino.
    // Use pin 5 for MOSI.
    // Use pin 6 for MISO.
    // Use pin 7 for SCK.
    SPI spi( p5, p6, p7 );
    // 8MHz clock should be OK.
    spi.frequency( 8000000 );
    // Set SPI format to use.
    // Use 8 bits per SPI frame.
    // Use SPI mode 0.
    spi.format( 8, 0 );
    // Make a Gameduino and pass SPI link and digital output for chip select.
    Gameduino gd( &spi, &cs );
    // Reset the Gameduino.
    gd.begin();
    // Lets have a default ASCII character set.
    gd.ascii();
    // Fill sprite image and palette memory.
    gd.copy( Gameduino::RAM_SPRIMG, sprite_sprimg, sizeof( sprite_sprimg ) );
    gd.copy( Gameduino::RAM_SPRPAL, sprite_sprpal, sizeof( sprite_sprpal ) );
    // Read from ident register.
    UInt8 id = gd.rd( Gameduino::IDENT );
    // Report back to PC.
    pc.printf( "Gameduino ID is 0x%02X.\r\n", (int)id );
    // Write something to character memory.
    gd.__wstart( Gameduino::RAM_PIC );
    for( UInt8 c = 'A'; c <= 'Z'; ++c ) {
        gd.__tr8( c );
    }
    gd.__end();
    // Test copy method.
    UInt8 copyData[] = "HELLO";
    gd.copy( Gameduino::RAM_PIC + 64, copyData, 5 );
    // Test putstr method.
    gd.putstr( 3, 10, "Ambidextrous!" );
    // Show some sprites.
    UInt16 y = 140;
    UInt8 spriteNum = 0;
    for( UInt8 rot = 0; rot < 8; ++rot ) {
        UInt16 x = 0;
        for( UInt8 spriteImage = 0; spriteImage < 10; ++spriteImage ) {
            gd.sprite( spriteNum++, x, y, spriteImage, 0, (Gameduino::Rotation)rot );
            x += 18;
        }
        y += 18;
    }
    // Test out sprite2x2 method.
    gd.sprite2x2( 90, 150, 16, 38, 0, Gameduino::None, 0 );
    // Test out __wstartspr method.
    gd.__wstartspr( 95 );
    y = 32;
    for( UInt8 imageNum = 15; imageNum < 19; ++imageNum ) {
        gd.TransferSprite( 150, y, imageNum, 0 );
        y += 16;
    }
    gd.__end();
    // Test out plots method.
    TestPlots( &gd );
    // Do some sprite animation.
    AnimationTest( &gd );
    // Make a noise.
    gd.voice( 25, Gameduino::SineWave, 8000, 127, 127 );
    wait_ms( 1000 );
    gd.voice( 25, Gameduino::SineWave, 0, 0, 0 );
    // Make another noise.
    gd.voice( 25, Gameduino::WhiteNoise, 8000, 127, 127 );
    wait_ms( 1000 );
    gd.voice( 25, Gameduino::WhiteNoise, 0, 0, 0 );
    // Finished with Gameduino.
    gd.end();
}
