#include "Pokitto.h"

#define STATE_IDLE    0
#define STATE_RUNNING 1

// the pokitto core library
Pokitto::Core pokitto;

/* Map EXTn outputs to inputs on L298 Full Bridge Driver */
DigitalOut ena = DigitalOut(EXT0);
DigitalOut enb = DigitalOut(EXT1);
DigitalOut in1 = DigitalOut(EXT2);
DigitalOut in2 = DigitalOut(EXT3);
DigitalOut in3 = DigitalOut(EXT4);
DigitalOut in4 = DigitalOut(EXT5);

int state;

int script[] = {1, 1, 4, -1, -1, 4, 1, -1, 4, -1, 1, 4, 0, 0, 0};
int step;
int substep;

void init(void)
{
    state = STATE_IDLE;
    ena.write(0);
    enb.write(0);
    in1.write(0);
    in2.write(0);
    in3.write(0);
    in4.write(0);
}

void set_motors(int a, int b)
{
    ena.write(1);
    enb.write(1);
    if (a == -1)
    {
        in1.write(0);
        in2.write(1);
    }
    else if (a == 1)
    {
        in1.write(1);
        in2.write(0);
    }
    else
    {
        in1.write(1);
        in2.write(1);
    }
    if (b == -1)
    {
        in3.write(0);
        in4.write(1);
    }
    else if (b == 1)
    {
        in3.write(1);
        in4.write(0);
    }
    else
    {
        in3.write(1);
        in4.write(1);
    }
}

void run(void)
{
    if (substep == 0)
    {
        set_motors(script[step], script[step + 1]);
        substep = script[step + 2];
    }
    substep--;
    if (substep == 0)
    {
        step +=  3;
        if (script[step] == 0)
            state = STATE_IDLE;
    }
}

void stop(void)
{
    ena.write(0);
    enb.write(0);
    in1.write(1);
    in2.write(1);
    in3.write(1);
    in4.write(1);
}

int main ()
{
    // initialise the Pokitto
    pokitto.begin();

    // the main loop
    while (pokitto.isRunning())
    {
        // update the Pokitto's state
        if (pokitto.update())
        {
            switch (state)
            {
            case STATE_IDLE:
                pokitto.display.print("Idle");
                stop();
                if (pokitto.buttons.aBtn())
                {
                    state = STATE_RUNNING;
                    step = 0;
                    substep = 0;
                }
                break;
            case STATE_RUNNING:
                pokitto.display.print("Running");
                run();
                if (pokitto.buttons.aBtn())
                    state = STATE_IDLE;
                break;
            }
        }
        wait_ms(100);
    }

    return 1;
}