#include "mbed.h"
#include "C12832.h"
#include "LM75B.h"
#include "EthernetInterface.h"



DigitalOut aliveLed(LED1);

PwmOut led(p24);
PwmOut buzzer(p26);
LM75B tmp(p28,p27);
C12832 lcd(p5, p7, p6, p8, p11);
AnalogIn pot(p20);
Serial pc(USBTX,USBRX);
TCPSocketServer server;

InterruptIn joyStickUp(p12);
InterruptIn joyStickDown(p15);
DigitalIn joyStickCenter(p14);
DigitalIn joyStickLeft(p13);
DigitalIn joyStickRight(p16);

EthernetInterface eth;

bool stop;
char temp [50];
char ids[20];
char CRC;
char destination[15];

float currentTemperature;
char potentiometer;

unsigned char targetId;

const unsigned int id = 107; //ip address = 192.168.1.107


bool checkCRC()
{
    pc.printf("check CRC: CRC correct\n\r");
    return true;
}

char calcCRC()
{
    pc.printf("calculate crc\n\r");
    return 0xab;
}

void sendBuffer(int id, char* buffer,int length)
{
    pc.printf("send buffer to 192.168.1.%3d with a length of %2d\n\r",id,length);
    if(!stop) {
        sprintf("192.168.1.%3d",destination, 100+targetId);
        TCPSocketConnection client2;
        client2.connect(destination,4000);
        client2.send_all(buffer, length);
    }
}

/*-----------------------------------------------------------------------------
*  interrupt routines for joystick up, down & center
*-----------------------------------------------------------------------------*/
void joyStickUpISR(void)
{
    aliveLed=!aliveLed;
    if(targetId<16) targetId++;
    //pc.printf("Next Node: 192.168.1.%3d",100+targetId);
}

void joyStickDownISR(void)
{
    aliveLed=!aliveLed;
    if(targetId>0) targetId--;
    //pc.printf("Next Node: 192.168.1.%3d",100+targetId);
}

void joyStickEnter()
{
    char firstFrame[11];
    firstFrame[0]=0xAA;
    firstFrame[1]=0x55;
    firstFrame[2]=0;
    firstFrame[3]=targetId;
    firstFrame[4]=pot.read();
    firstFrame[5]=107;
  //  int a, b;
   // tmp.readRaw(&a,&b);
    firstFrame[6]=9;
    firstFrame[7]=8;
    firstFrame[8]=calcCRC();
    firstFrame[9]=0xaa;
    firstFrame[10]=0x55;

    stop=false;

    aliveLed=!aliveLed;

    char buffer [16];

    //sprintf (buffer, "192.168.1.%03d", 100+targetId, 16);
    pc.printf("sending first frame to 192.1681.100 ");
    pc.printf(buffer);
    pc.printf("\n\r");
    TCPSocketConnection client2;

   // pc.printf("destination: %s", buffer);
      while (client2.connect("192.168.1.100", 4000) < 0) {
        pc.printf("Unable to connect to (%s) on port (%d)\n\r", "192.168.1.100", 4000);
    }
     char hello[] = "Hello World";
      int succes = client2.send_all(hello,sizeof(hello)-1);
    //int succes = client2.send_all(firstFrame,sizeof(firstFrame));

    if(succes>0) {
        pc.printf("%d bytes transmitted succesfully\n\r",succes);
    } else {
        pc.printf("ERROR SENDING FIRST FRAME\n\r");
    }
    pc.printf("\n\r");
   client2.close();
}

/*------------------------------------------------------------------------------
 play the first n notes
------------------------------------------------------------------------------*/

double frequencies[] =    { 110,110,110,98,130,110,98,130,110,165,165,165,175,130,104,98,130};
int length[] =         { 480,480,480,360,120,480,360,120,960,480,480,480,360,120,480,360,120};
char delay[] =          { 100,100,100,075,100,100,075,100,100,100,100,100,075,100,100,075,100};

void playTune(int n)
{
    pc.printf("play %d notes from tune\n\r", n);
    for(int i = 0; i<n; i++) {
        buzzer.write(0.5);
        int period = 1000000/frequencies[i];
        buzzer.period_us(period);
        wait_ms(length[i]);
        buzzer.write(0);
        wait_ms(delay[i]);
    }
}

/*------------------------------------------------------------------------------
/ print ip address, target ip, temperature and potentiometer value on LCD
------------------------------------------------------------------------------*/

void printLCD(void)
{
    // pc.printf("update lcd\n\r");
    lcd.locate(0,8);
    lcd.printf("target =     192.168.1.%3d",100+targetId);
    lcd.locate(0,23);
    potentiometer = (char) 255*pot.read();
    // pc.printf("potvalue %d \r\n" , potentiometer);
    lcd.printf("pot is = %2d", potentiometer);

}


/*-----------------------------------------------------------------------------
/init routine
/
/ UART
/ -set the baudrate to 115200
/
/ Ethernet connection
/ set up ethernet connection with static ip 10.182.34.107 and make connection
/
/ LCD
/ clear LCD
/ run printLCD()
/
/ Add Interrupt to joystick up, down & center
/ PWM: init PWM for (R)G(B) led.
/ Tune: plays 3 notes from tune when finished
------------------------------------------------------------------------------*/


void init(void)
{
    pc.baud(9600);
    pc.printf("\n\n\r projectlab Rian De Rous \n\r\n");
    //setup an eternet connection. IP ADDRESS = 192.168.1.107
    //int result = eth.init("192.168.1.107","255.255.255.0","192.168.1.1");
    pc.printf("initialisatie ethernet connectie \n\r");
    // eth.init("192.168.1.107","255.255.255.0","192.168.1.1");
    eth.init("192.168.1.107", "255.255.255.0", "192.168.1.1");
    //pc.printf("IP Address is %s \n\r", eth.getIPAddress());
    pc.printf("try to connect\r\n");



    if(eth.connect()==0) {
        pc.printf("connectie geslaagd\r\n");
    } else {
        pc.printf("connectie gefaald\r\n");
    }


    server.bind(4000);
    server.listen();

    pc.printf("initialisatie lcd\n\r");
    //lcd initialisation
    lcd.cls();                                 // good practice to clear lcd on startup
    lcd.locate(0,0);
    lcd.printf("IP Address is %s \n\r", eth.getIPAddress());// print ip address to first line on lcd


    //add interrupt routines
    pc.printf("initialisatie interrupts\n\r");
    joyStickUp.rise(&joyStickUpISR);           // interrupt on joystick up     --> jump to joyStickUpISR       on Interrupt
    joyStickDown.rise(&joyStickDownISR);       // interrupt on joystick down   --> jump to joyStickDownISR     on Interrupt

    pc.printf("initialisatie tcp server\n\r");
    server.bind(4000);
    server.listen();

    pc.printf("initialisatie led");
    led.period_ms(1); // 1kHz pwm Out frequency to dim green led in RGB led.
    led.write(0.95);

    pc.printf("play tune!\n\r");
    playTune(0);

}

float tmpToFloat(char a, char b)
{
    pc.printf("convert 2 byte temperature value to a float");
    return float((a<<8)|b) / 256.0 ;
}

float averageTemperature(int n, char * temp)
{
    pc.printf("calculate average temperature\n\r");
    float avgtemp;

    for(int i=0; i<n; i++) {
        avgtemp+=tmpToFloat(temp[3*i],temp[3*i+1]);

    }
    avgtemp=avgtemp/n;
    lcd.locate(0,16);
    lcd.printf("average temp is = %.2f\n",avgtemp);
    return  avgtemp;
}

int main()
{
    init();
    while (true) {

        printLCD();
        if(joyStickCenter.read()==1) {
            joyStickEnter();
            wait(0.2);
        }
          if(joyStickLeft.read()==1) {
            playTune(10);
            wait(0.2);
        }
         if(joyStickRight.read()==1) {
              lcd.locate(64,23);
              lcd.printf("temp is %.2f°C\n",tmp.read());
            wait(0.2);
        }
        
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(true, 15000); // Timeout after (1.5)s
      //  if(client.get_address()!=null) {
        //    printf("Connection from: %s \r\n", client.get_address());
       // }
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;

            int count=0;
            //check if frame starts with 0xAA55

            if(buffer[0]==0xaa && buffer[1]==0x55) {

                count = 5;
                //extract temperatures from buffer
                for(int i = 0; i<3* buffer[2]; i++, count++) {
                    temp[i]=buffer[count];
                }
                //extract CRC checksum from buffer
                count++;
                CRC = buffer[count];
                count++;

                int i = 6;
                stop = false;
                while(stop == false && i<(buffer[2]*3+6)) {
                    stop =true;
                    i+=3;
                }

                //check if packet is (in)valid
                if((buffer[count]==0x55 && buffer[count+1]==0xAA)) {

                    led.write(buffer[4]);
                    playTune(buffer[2]);

                    averageTemperature(buffer[2],temp);

                    if(!stop) {
                        buffer[2]++;
                        buffer[3]=targetId;
                        buffer[4]=pot.read();
                        count++;

                        buffer[count-1]=id;
                        int a, b;
                        tmp.readRaw(&a,&b);
                        buffer[count]=  a;  // nog om te zetten met complement
                        buffer[count+1]=b;
                        buffer[count+2]=calcCRC();
                        buffer[count+3]=0x55;
                        buffer[count+4]=0xAA;
                        sendBuffer(targetId, buffer,count +4);
                        if(!checkCRC()) {
                            //correct packet
                        }
                    }

                }
                stop = false;
            }
            client.close();
        }
    }

}
