#include "L298HBridge.h"
#include "mbed.h"
 
 
L298HBridge::L298HBridge(PinName ENPin, PinName FWDPin, PinName REVPin) : _ENPin(ENPin), _FWDPin(FWDPin), _REVPin(REVPin) {
    _ENPin = 0;     //PWM = 0%
    _FWDPin = 0;
    _REVPin = 0;
    _ENPin.period(0.020); //set PWM period to 20mS as default.
}
 
void L298HBridge::Fwd() {    
    _FWDPin = 1;
    _REVPin = 0;
}

void L298HBridge::Rev() {
    _FWDPin = 0;
    _REVPin = 1;
}

void L298HBridge::Stop() {
    _FWDPin = 0;
    _REVPin = 0;
}
 
void L298HBridge::Speed(float DutyPercent) {    
    _ENPin = DutyPercent /100;
}