#ifndef _METER_H_
#define _METER_H_
/**
 * meter class 
 * A simple analog style meter
 **/

class meter {
public:
/**
 * meter constructor
 * @param x right-top position of meter
 * @param y right-top position of meter
 * @param width width of meter
 * @param height height of meter
 * @param min minimum value of meter
 * @param max maximum value of meter
 */
meter(int x, int y, int width, int height, float min, float max) ;

/**
 * meter destructor
 */
~meter(void) ;

/**
 * drawFrame draw meter frame/canvas
 */
void drawFrame(void) ;

/**
 * drawScale draw measuring mark 
 */
void drawScale(void) ;

/**
 * drawHand draw meter hand at value position
 * @param value value to plot the hand
 */
void drawHand(float value) ;

/**
 * drawValue draw textual value in the lower part of the meter
 * @param value value to display (voltage assumed)
 */
void drawValue(float value) ;

/**
 * draw draw full set of the meter
 * @param value value to display and put hand
 */
void draw(float value) ;

/**
 * update draw only hand and value text
 */
void update(float value) ;

private:
int _x ;
int _y ;
int _w ;
int _h ;
int _center_x ;
int _center_y ;
float _min ;
float _max ;

} ;

#endif /* _METER_H_ */