/**
 * main.cpp
 */
#include "mbed.h"
#include "ILI9341.h"
#include "Arial28x28.h"
#include "vt100.h"
#include "meter.h"
#include "main.h"

#define ADC_MAX_VALUE 3.28

vt100        *tty = 0 ;
ILI9341      *tft = 0 ;
meter        *tacho = 0 ;

DigitalOut *backlight = 0 ;
AnalogIn   *vin = 0 ;

float min_value = 0.0 ;
float max_value = 3.3 ;

void initTFT(void)
{
    //Configure the display driver
    tft->BusEnable(true) ;
    tft->FastWindow(true) ;
    tft->background(Black);
    tft->foreground(White);
    wait(0.01) ;
    tft->cls();
    tft->BusEnable(false) ;
    backlight = new DigitalOut(PIN_BL_TFT, 1) ;
}

void init_hardware(void)
{
    tty = new vt100() ;
    tty->cls() ;
    tft = new ILI9341(SPI_8, 10000000, 
      PIN_MOSI, PIN_MISO,  PIN_SCLK, 
      PIN_CS_TFT, PIN_RESET_TFT, PIN_DC_TFT, "Adafruit2.8") ;
    initTFT() ;
    tft->set_font((unsigned char*) Arial28x28);
    tft->foreground(White) ;
    tacho = new meter(5, 5, 230, 230, 0.0, 3.3) ;
    vin = new AnalogIn(PIN_ADC_CH0) ;
    *backlight = 1 ;
}

double getRoundedValue(void)
{
    double value = 0.0 ;
    int intvalue = 0 ;
    value = ADC_MAX_VALUE * vin->read() ;
    intvalue = (int)(1000.0 * value + 0.5) ;
    value = (double)intvalue / 1000.0 ;
    return( value ) ;
}

int main() {
    float value = 0.0 ;
    float prev_value = 0.0 ;
 
    init_hardware() ;
    tacho->draw(value) ;
    
    while(1) {
        value = getRoundedValue() ;
        printf("%.2f\n", value) ;
        if (value != prev_value) {
            tacho->update(value) ;
            prev_value = value ;
        }
        wait(0.1) ;
    }
}
