#include "mbed.h"
#include "vt100.h"

/** test_vt100
 * test program for my vt100 library
 * 
 * terminal program must be at least 80x25
 * and needless to say, should supporting vt100 commands
 */
 
vt100 tty ;

int left = 2 ;
int top = 2 ;
int right = 78 ;
int bottom = 23 ;
int h_center = 40 ;
int v_center = 12 ;

void drawFrame(void)
{
    tty.frame(left, top, right, bottom) ;
    tty.line(left+1, v_center, right-1, v_center, '-') ;
    tty.line(h_center, top+1, h_center, bottom-1, '|') ;
    tty.putChar(h_center, v_center, '+') ;
}

int clip(int y)
{
    if (y > bottom) {
        y = bottom ;
    } else if (y < top) {
        y = top ;
    }
    return( y ) ;
}

void drawYeqX(void)
{
    int x, y ;
    drawFrame() ;
    for (x = left+1 ; x < right ; x++ ) {
        y = v_center - (x - h_center) / 4 ;
        tty.putChar(x, y, '*') ;
    }
    tty.locate(left + 2, top + 2) ;
    printf("Y = X\n\r") ;
}

void drawYeqXX(void)
{
    int x, y ;
    drawFrame() ;
    for (x = left+1 ; x < right ; x++ ) {
        y = clip( bottom - 1 - ((x - h_center)*(x - h_center) / 80)) ;
        tty.putChar(x, y, '*') ;
    }
    tty.locate(left + 2, top + 2) ;
    printf("Y = X^2 - 1\n\r") ;
}

void drawYeqXXX(void)
{
    int x, y ;
    drawFrame() ;
    for (x = left+1 ; x < right ; x++ ) {
        y = clip(v_center - ((x - h_center)*(x - h_center)*(x - h_center) / 3200)) ;
        tty.putChar(x, y, '*') ;
    }
    tty.locate(left + 2, top + 2) ;
    printf("Y = X^3\n\r") ;
}

void drawCircle(void)
{
    drawFrame() ;
    tty.circle(h_center, v_center, 8) ;
    tty.locate(left + 2, top + 2) ;
    printf("Y^2 + X^2 = 1\n\r") ;
}

int main() {
    int count = 0 ;
    while(1) {
        tty.cls() ;
        tty.locate(10, 1) ;
        printf("<< vt100 library test program >>") ;
        drawFrame() ;
        switch(count++) {
        case 0: drawYeqX() ; break ;
        case 1: drawYeqXX() ; break ;
        case 2: drawYeqXXX() ; break ;
        case 3: drawCircle() ; break ;
        default: count = 0 ; continue ;
        }
         wait(4.0) ;
    }
}
