/** Test Spi a quick and dirty spi test program
 */
 
#include "mbed.h"
#include <string.h>
#include <stdio.h>
#include "MSS.h"

#if 0
#define PIN_MOSI        PTD2
#define PIN_MISO        PTD3 
#define PIN_SCLK        PTD1 
#define PIN_CS_TSC      PTA13
#define PIN_TSC_INTR    PTC9
#define PIN_MSS_CS      PTD0
#endif 

int freq = 1000000 ;
int bits = 8 ;
int mode = 0 ;
int loop = 10 ;

SPI mySpi(PIN_MOSI, PIN_MISO, PIN_SCK) ;
DigitalOut cs(PIN_INT0, 1) ;

typedef void (*func_ptr)(void) ;

void doHelp(void) ;
void doStatus(void) ;
void doFreq(void) ;
void doMode(void) ;
void doBit(void) ;
void doWrite(void) ;
void doRead(void) ;
void doLoop(void) ;

typedef struct _cmd_func {
    char *name ;
    func_ptr func ;
} cmd_func_type ;

cmd_func_type cmd_list[] = {
    {"help", doHelp},
    {"status", doStatus},
    {"freq", doFreq},
    {"mode", doMode},
    {"bit",  doBit},
    {"write", doWrite},
    {"read",  doRead},
    {"loop", doLoop},
    { 0, 0 }
} ;

func_ptr getFunc(char *cmd)
{
    int i = 0 ;
    while(cmd_list[i].name != 0) {
        if (strcmp(cmd, cmd_list[i].name) == 0) {
            return(cmd_list[i].func) ; ;
        }
        i++ ;
    }
    return(0) ;
}

void doHello()
{
    printf("=== spi test program ===\n\r") ;
    printf("please set your terminal program\n\r") ;
    printf("local echo on\n\r") ;
    printf("\n\r") ; 
}
    
int main() {
    char cmd[32] ;
    func_ptr func ;
    doHello() ;
    while(1) {
        printf("> ") ;
        scanf("%s", cmd) ;
        if ((func = getFunc(cmd)) != 0) {
            (*func)() ;
        } else {
            doHelp() ;
        }
        printf("\n\r") ;
    }
}

void doHelp(void) 
{
    printf("=== spi test ===\n\r") ;
    printf("commands available\n\r") ;
    printf("help\n\r") ;
    printf("status\n\r") ;
    printf("freq freq_in_hz\n\r") ;
    printf("mode (0 | 1 | 2 | 3)\n\r") ;
    printf("bit (4 - 16)\n\r") ;
    printf("write value\n\r") ;
    printf("read\n\r") ;
    printf("loop number (set repeat number for read/write)\n\r") ;
}

void doStatus(void)
{
    printf("=== Status Report ===\n\r") ;
    printf("bits: %d\n\r", bits) ;
    printf("mode: %d\n\r", mode) ;
    printf("freq: %d Hz\n\r", freq) ;
    printf("loop: %d\n\r", loop) ;
}

void doFreq(void)
{
    int freq = 0 ;
    scanf("%d", &freq) ;
    printf("setting frequency to %d\n\r", freq) ;
    mySpi.frequency(freq) ;
}

void doMode(void)
{
    scanf("%d", &mode) ;
    printf("setting format(%d, %d)\n\r",bits, mode) ;
    mySpi.format(bits, mode) ;       
}

void doBit(void) 
{
    scanf("%d", &bits) ;
    printf("setting format(%d, %d)\n\r",bits, mode) ;
    mySpi.format(bits, mode) ;
}

void doWrite(void) 
{
    int value, i ;
    scanf("%X", &value) ;
    printf("writing value 0x%X (%d) \n\r",value, value) ;
    cs = 0 ;
    for (i = 0 ; i < loop ; i++ ) {
        mySpi.write(value) ;
    }
    cs = 1 ;
}

void doRead(void) 
{
    int dummy = 0 ;
    int i ;
    int value = 0 ;
    cs = 0 ;
    for (i = 0 ; i < loop ; i++ ) {
        value = mySpi.write(dummy) ;
    }
    cs = 1 ;
    printf("%d\n", value) ;
}

void doLoop(void)
{
    scanf("%d", &loop) ;
    printf("repeat number has been set to %d\n\r", loop) ;
}