#include "mbed.h"
#include "MSS.h"
#include "VCNL4010.h"

#define VCNL4010_I2C_ADDRESS 0x13
#define ALS_EN       0x04
#define ALS_READY    0x40
#define PROX_EN      0x02
#define PROX_READY   0x20
#define SELFTIMED_EN 0x01

int main() {
    uint8_t data8 ;
    uint16_t data16 ;
    int sample ;
    
    VCNL4010 *vcnl4010 = new VCNL4010(PIN_SDA, PIN_SCL, VCNL4010_I2C_ADDRESS) ;
    
    printf("=== test VCNL4010 for %s (%s) ===\n", BOARD_NAME, __DATE__) ;
    data8 = vcnl4010->getProductID() ;
    printf("Product ID = %d, Revision = %d\n",
        (data8 >> 4)&0xF, data8&0xF ) ;
    data8 = vcnl4010->getProxRate() ;
    printf("Proximty Rate = %d\n", data8 & 0x7) ;
    data8 = vcnl4010->getIrLedCurrent() ;
    printf("Fuse Prog ID = %d, IR LED Current Value = %d mA\n",
        (data8 >> 6) & 0x3, (data8 & 0x3F) * 10) ;
    data8 = vcnl4010->getAlsParam() ;
    printf("Continuous conversion mode: %s\n",
        (data8 & 0x80) ? "Enabled" : "Disabled" ) ;
 
    switch((data8 >> 4) & 0x7) {
    case 0: sample = 1 ; break ;
    case 1: sample = 2 ; break ;
    case 2: sample = 3 ; break ;
    case 3: sample = 4 ; break ;
    case 4: sample = 5 ; break ;
    case 5: sample = 6 ; break ;
    case 6: sample = 8 ; break ;
    case 7: sample = 10 ; break ;
    }
    printf("Ambient light measurement rate = %d samples/s\n",sample) ;
    printf("Automatic offset compensation: %s\n",
        (data8 & 0x2) ? "Enabled" : "Disabled" ) ;    
    printf("Averaging function: %d\n", 0x01 << (data8 & 0x7)) ;
    vcnl4010->setCommandReg( ALS_EN | PROX_EN | SELFTIMED_EN ) ; 
    while(1) {
        data8 = vcnl4010->getCommandReg() ;
        if (data8 & ALS_READY) {
            data16 = vcnl4010->getAls() ;
            printf("Ambient Light Result = %d\n", data16) ;
        }
        if (data8 & PROX_READY) {
            data16 = vcnl4010->getProx() ;
            printf("Proximity Measurement Result = %d\n", data16) ;
        }
        wait(1) ;
    }
}
