/* main.cpp to test touch sensor comes with adafruit 2.8" TFT LCD shield 
 * Copyright (c) 2014 Motoo Tanaka @ Design Methodology Lab
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 /*
  * Note: Since the interrupt siganl of the shield was not connected
  * to an interrupt pin on my frdm-kl25z, I just used polling mode.
  */
#include "mbed.h"
#include "vt100.h"
#include "SPI_STMPE610.h"

vt100 *tty = 0 ;

#if   defined (TARGET_KL25Z) 
#define PIN_MOSI        PTD2
#define PIN_MISO        PTD3 
#define PIN_SCLK        PTD1 
#define PIN_CS_TFT      PTD0 
#define PIN_DC_TFT      PTD5 
#define PIN_BL_TFT      PTC9 
#define PIN_CS_SD       PTA4 
#define PIN_CS_TSC      PTA13
#define PIN_TSC_INTR    PTC9
#define DEVICE_NAME     "KL25Z"

#elif defined (TARGET_KL46Z)
#define PIN_MOSI        PTD6
#define PIN_MISO        PTD7 
#define PIN_SCLK        PTD5 
#define PIN_CS_TFT      PTD4 
#define PIN_DC_TFT      PTD2 
#define PIN_BL_TFT      PTC9 
#define PIN_CS_SD       PTA4 
#define PIN_CS_TSC      PTA13
#define PIN_TSC_INTR    PTC9
#define DEVICE_NAME     "KL46Z"

#elif defined (TARGET_K64F)
#define PIN_MOSI        PTD2
#define PIN_MISO        PTD3
#define PIN_SCLK        PTD1
#define PIN_CS_TFT      PTD0
#define PIN_DC_TFT      PTC4
#define PIN_BL_TFT      PTC3
#define PIN_CS_SD       PTB23
#define PIN_CS_TSC      PTA0
#define PIN_TSC_INTR    PTC3
#define PIN_RESET_TFT   PTB20
#define PIN_ADC_CH0     PTB2
#define PIN_ADC_CH1     PTB3
#define DEVICE_NAME     "K64F"

#elif defined (TARGET_NECLEO_F411RE)
#define PIN_MOSI        PA_7
#define PIN_MISO        PA_6  
#define PIN_SCLK        PA_5 
#define PIN_CS_TFT      PB_6 
#define PIN_DC_TFT      PC_7 
#define PIN_BL_TFT      PA_8 
#define PIN_CS_SD       PB_5 
#define PIN_CS_TSC      PA_9 
#define PIN_TSC_INTR    PA_8
#define PIN_RESET_TFT   PC_13 /* place holder */
#define DEVICE_NAME     "F411RE"

#elif defined (TARGET_MAX32600MBED)
/* I2C */
#define PIN_SCL  P2_7
#define PIN_SDA  P2_6
/* SPI */
#define PIN_SCLK  P2_0
#define PIN_MISO P2_2
#define PIN_MOSI P2_1
// #define PIN_MISO P2_1
// #define PIN_MOSI P2_2
#define PIN_CS0  P2_3
/* Interrupt */
#define PIN_INT0 P2_4
#define PIN_INT1 P2_5
#define PIN_INT2 P1_7
#define PIN_INT3 P1_6
#define PIN_INT4 P1_5
#define PIN_INT5 P1_4
/* Analog In */
#define PIN_AN0  AIN_0P
#define PIN_AN1  AIN_1P
#define PIN_AN2  AIN_2P
#define PIN_AN3  AIN_3P
#define PIN_AN4  AIN_4P
#define PIN_AN5  AIN_5P
#define BOARD_NAME "MAX32600MBED"
#define DEVICE_NAME "MAX32600MBED"

#define PIN_CS_TFT      P2_3 // D10 PTD0 
#define PIN_DC_TFT      P2_4 // D9  PTD5 
#define PIN_CS_TSC      P2_5 // D8  PTA13
#define PIN_BL_TFT      P1_7 // D7   PTC9 
#define PIN_CS_SD       P1_4 // D4   PTA4 
#define PIN_TSC_INTR    P5_4 // PTC9 /* place holder */
#define PIN_RESET_TFT   P5_5 /// PTB10 /* place holder */
#define PIN_ADC_CH0     AIN_0P // A0 PTB0
#define PIN_ADC_CH1     AIN_2P // A2 PTB2

#else
  #error TARGET NOT DEFINED
#endif

DigitalOut tft_cs(PIN_CS_TFT, 1) ;
DigitalOut sd_cs(PIN_CS_SD, 1) ;
DigitalOut tsc_cs(PIN_CS_TSC, 1) ;
// DigitalOut tsc_intr(PIN_TSC_INTR) ; // should be input, just for test
// DigitalOut tft_reset(PIN_RESET_TFT, 1) ;

int main()
{
    uint16_t touched, x, y, z ;
    SPI_STMPE610 *tsc ;
#if (TARGET_MAX32600MBED)
    uint32_t *SPI0_MSTR_CFG = (uint32_t*)0x40030000 ;
    tty = new vt100(57600) ;
#else
    tty = new vt100() ;
#endif
    tty->cls() ;
    
    tsc = new SPI_STMPE610(PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TSC) ;
 //   tsc->spi_frequency(1000000) ; 
 //   tsc->spi_format(8, 0) ;
    printf("Test SPI STMPE610 (%s:%s)\n\r", DEVICE_NAME, __DATE__) ;

    tft_cs = 1 ; /* disable TFT display */
    sd_cs = 1 ; /* disable SD */

    while (true) {
        touched = tsc->getRAWPoint(&x, &y, &z) ;
        if (touched) {
            printf("x = %d, y = %d, z = %d\n\r", x, y, z) ;
        }
        wait(0.1) ;
    }
}