#include "mbed.h"
#include "MSS.h"
#include "S11059.h"

#define MSU_S11059_ADDRESS 0x2A

int main(void) 
{
    uint16_t uR, uG, uB, uIR ;
    uint8_t ctrl ;

    S11059 *s11059 = new S11059(PIN_SDA, PIN_SCL, MSU_S11059_ADDRESS) ;
    printf("=== test S11059 for %s (%s) ===\n", BOARD_NAME, __DATE__) ;
    printf("     R,      G,      B,     IR\n") ;
    
    while(1) {
        ctrl = 0x89 ; // ADC reset, High Gain, integration time 1.4ms 
        s11059->setControl(ctrl) ;
        ctrl = 0x09 ; // Release ADC reset, High Gain, integration time 1.4ms 
        s11059->setControl(ctrl) ; // start measure 
        wait(0.02) ;
        s11059->getRData(&uR) ;
        s11059->getGData(&uG) ;
        s11059->getBData(&uB) ;
        s11059->getIRData(&uIR) ;
        printf("%6d, %6d, %6d, %6d\n", uR, uG, uB, uIR) ;
        wait(1) ;
    }
}