#include "mbed.h"
#include "MSS.h"
#include "MAX30205.h"

#define MAX30205_I2C_ADDRESS 0x48

int main() {
    uint16_t temp, thyst, tos ;
    MAX30205 *max30205 = new MAX30205(PIN_SDA, PIN_SCL, MAX30205_I2C_ADDRESS) ;
    
    printf("=== test MAX30205 for %s (%s) ===\n", BOARD_NAME, __DATE__) ;
    printf("Temp,   Thyst,  Tos\n") ;
    temp  = max30205->getTemp() ;
    thyst = max30205->getThyst() ;
    tos   = max30205->getTos() ;
    printf("%4.3f, %4.3f, %4.3f\n", 
        (float)temp/256.0, (float)thyst/256.0, (float)tos/256.0) ;
    printf("Temperature (C degree)\n") ;
    while(1) {
        temp = max30205->getTemp() ;
        printf("%4.3f\n",(float)(temp)/256.0) ;
        wait(1) ;
    }
}
