#include "mbed.h"
#include "MSS.h"
#include "HDC1000.h"

#define HDC1000_I2C_ADDRESS   0x40

HDC1000 *hdc1000 = 0 ;

int main() {
    float temp, hume ;
    uint16_t dev_id, man_id ;
    int mode = 0 ;

    hdc1000 = new HDC1000(PIN_SDA, PIN_SCL, PIN_INT0, HDC1000_I2C_ADDRESS) ;
    hdc1000->reset() ;
    wait(1) ;
    
    printf("=== test HDC1000 for %s (%s) ===\n", BOARD_NAME, __DATE__) ;
    dev_id = hdc1000->getDeviceID() ;
    printf("Device      ID = 0x%04X\n", dev_id) ;
    man_id = hdc1000->getManufactureID() ;
    printf("Manufacture ID = 0x%04X\n", man_id) ;

    while(1) {
        printf("mode = %d ", mode) ;
        hdc1000->setMode(mode) ;
        wait(1) ;
        if (mode == 1) {
            hdc1000->readData(&temp, &hume) ;
        } else {
            temp = hdc1000->readTemperature() ;
            hume = hdc1000->readHumidity() ;
        }
        printf("Temperature: %.2f C  Humidity: %.2f %%\n",temp, hume) ;
        wait(1) ;
        mode = (mode == 0) ? 1 : 0 ;
    }
}
