#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"
#include "BMI160.h"

MAX32630FTHR *sakura = 0 ;
USBSerial    *microUSB ;
BMI160       *bmi160 = 0 ;
Serial       *daplink = 0 ;
DigitalOut   *LED_R = 0 ;
DigitalOut   *LED_G = 0 ;
DigitalOut   *LED_B = 0 ;

#define PIN_RX2  P2_0
#define PIN_TX2  P2_1
#define PIN_SDA2 P5_7
#define PIN_SCL2 P6_0
#define PIN_LED_R P2_4
#define PIN_LED_G P2_5
#define PIN_LED_B P2_6
#define BMI160_I2C_ADDRESS 0x68

void init_hardware(void)
{
    sakura = new MAX32630FTHR(MAX32630FTHR::VIO_3V3);
    daplink = new Serial(PIN_TX2, PIN_RX2, "daplink") ;

    bmi160 = new BMI160(PIN_SDA2, PIN_SCL2, BMI160_I2C_ADDRESS) ;
    LED_R = new DigitalOut(PIN_LED_R, 1) ;
    LED_G = new DigitalOut(PIN_LED_G, 1) ;
    LED_B = new DigitalOut(PIN_LED_B, 1) ;
    
    *LED_R = LED_OFF ;
    *LED_G = LED_ON ;
    *LED_B = LED_OFF ;
    
    // acc_set_pmu_mode 0x10 | ACC_PMU_XXX
    bmi160->setCMD(0x10 | ACC_PMU_NORMAL) ;
    wait(0.1) ;
    bmi160->setCMD(0x14 | GYR_PMU_NORMAL) ;
    wait(0.1) ;
    bmi160->setCMD(0x08 | MAG_PMU_SUSPEND) ;
    wait(0.1) ;
    bmi160->setCMD(0x03) ; /* start_foc */
    wait(0.1) ;

}

int main()
{
    int id = 0 ;
    float a[3], g[3] ;
    int acc_range, gyr_range, status ;
    
    init_hardware() ;

    printf("Hello World\n") ;

    id = bmi160->getChipID() ;
    printf("BMI160 ID = 0x%02X\n", id) ;
    acc_range = bmi160->getAccRange() ;
    gyr_range = bmi160->getGyrRange() ;
    printf("Acc range = +/- %d g, Gyr range = %d degree/sec\n", acc_range, gyr_range) ;
    
    while(1) {
        status = bmi160->getStatus() ;

        bmi160->getAcc(a) ;

        bmi160->getGyr(g) ;

        printf("ACC: %.2f, %.2f, %.2f ", a[0], a[1], a[2]) ;
        printf("GYR: %.2f, %.2f, %.2f\n", g[0], g[1], g[2]) ;
        wait(0.1) ;
    }
}

