#include "mbed.h"
#include "MSS.h"
#include "BME280.h"

#define SPI_IF 1
#define I2C_IF 2

#define BME280_I2C_ADDRESS 0x76

DigitalOut csb(PIN_CS0, 1) ;

int main() {
    float temp, hum, pres ;
    BME280 *bme280 = 0 ;
    int used_if = I2C_IF ; /* SPI_IF for SPI */
    
    if (used_if == I2C_IF) {
        bme280 = new BME280(PIN_SDA, PIN_SCL, BME280_I2C_ADDRESS) ;
    } else if (used_if == SPI_IF) {
        bme280 = new BME280(PIN_SCK, PIN_MISO, PIN_MOSI, PIN_CS0) ;
    } else {
        printf("Unsupported IF for BME280 [%d]\n", used_if) ;
        exit(EXIT_FAILURE) ;
    }

    bme280->reset() ;
    wait(2) ;
    bme280->init() ;
    wait(1) ;
    printf("\n=== test BME280 for %s (%s) ===\n", BOARD_NAME, __DATE__) ;
    if (used_if == I2C_IF) {
        printf("IF = I2C, ") ;
    } else if (used_if == SPI_IF) {
        printf("IF = SPI, ") ;
    }
    printf("ID = 0x%02X (0x60 expected for BME280)\n", bme280->getID()) ;
    
    printf("Temperature(C) , Humidity(%%), Pressure(hPa)\n") ;
    while(1) {
        bme280->trigger() ;
        while(bme280->busy()) {
            wait(0.1) ;
        }
        temp = bme280->getTemperature() ;
        hum = bme280->getHumidity() ;
        pres = bme280->getPressure() ;
        printf("%.2f, %.2f, %.2f\n", temp, hum, pres) ;
        wait(2) ;
    }
}
