#include <ctype.h>
#include "mbed.h"
#include "serial_api.h"
#include "SPI_M25PE20.h"

// SPI_M25PE20(PinName mosi, PinName miso, PinName sclk, PinName cs) ;
// FRDM_KL25Z
// D13 SPI0_SCK  (PTD1)
// D12 SPI0_MISO (PTD3) 
// D11 SPI0_MOSI (PTD2)
// D10 SPI0_PCS0 (PTD0)
SPI_M25PE20 spi_mem(PTD2, PTD3, PTD1, PTD0) ;

void usage(void)
{
    printf("=== commands ===\n\r") ;
    printf("read  address       (ex: read 0x0000)\n\r") ;
    printf("dump  address       (ex: dump 0x2000)\n\r") ;
    printf("rdsr                (read status register)\n\r") ;
    printf("wren                (write enable)\n\r") ;
    printf("wrdi                (write disable)\n\r") ;
    printf("write address value (program a 8bit data to the address)\n\r") ;
    printf("pp    address       (program page: ex pp 0x00)\n\r") ;
    printf("pe                  (page erase)\n\r") ;
    printf("se                  (sector erase)\n\r") ;
    printf("\n\r") ;
}

void dump(unsigned long address)
{
    unsigned int i, j ;
    unsigned char data[0x10] ;
    
    printf("       : ") ;
    for (i = 0 ; i < 0x10 ; i++ ) {
        printf("+%X ",i) ;
    }
    printf("\n\r") ;
    for (j = 0 ; j < 0x10 ; j++ ) {
        printf("%06X : ", address + (0x10 * j)) ; 
        for (i = 0 ; i < 0x10 ; i++ ) {
            data[i] = spi_mem.read8(address + 0x10 * j + i) ;
            printf("%02X ", data[i]) ;
        }
        printf(": ") ;
        for (i = 0 ; i < 0x10 ; i++ ) {
            if (isprint(data[i])) {
                printf("%c", data[i]) ;
            } else {
                printf(".") ;
            }
        }
        printf(" :\n\r") ;
    }
    printf("\n\r") ;
}    

int main() {
    char cmd[32] ;
    int tmp = 0 ;
    int i ;
    int numData = 256 ;
    unsigned long address = 0 ;
    unsigned char data[256] ;
    
   extern serial_t stdio_uart ;
   serial_baud(&stdio_uart, 115200) ;
    
    printf("\n\r============================\n\r") ;
    printf("M25PE20 test program\n\r") ;
    printf("please enable local echo\n\r") ;
    printf("============================\n\r") ;
    printf("\n\r") ;
    usage() ;
    
    while(1) {
        printf("> ") ;
        scanf("%s", cmd) ;
        if (strcmp(cmd, "read") == 0) {
            scanf("%X", &address) ;
            data[0] = spi_mem.read8(address) ;
            printf("%08X : 0x%02X\n\r", address, data[0]) ;
        } else if (strcmp(cmd, "rdsr") == 0) { // read status
            data[0] = spi_mem.readStatus() ;
            printf("status register = 0x%02X\n\r", data[0]) ;
        } else if (strcmp(cmd, "wren") == 0) { // write enable
            spi_mem.writeEnable() ;
            printf("done\n\r") ;
        } else if (strcmp(cmd, "wrdi") == 0) { // write disable
            spi_mem.writeDisable() ;
            printf("done\n\r") ;
        } else if (strcmp(cmd, "write") == 0) { // write a byte 
            scanf("%X", &address) ;
            scanf("%X", &tmp) ;
            data[0] = tmp & 0xFF ;
            printf("mem[0x%06X] <= 0x%02X\n\r",address, data[0]) ;
            spi_mem.writeEnable() ;
            spi_mem.programPage(address, data, 1) ;
            printf("done\n\r") ;
        } else if (strcmp(cmd, "pp") == 0) { // program page
            scanf("%X", &address) ;
            printf("writing %d bytes to 0x%X\n\r",numData, address) ;
            spi_mem.writeEnable() ;
            for (i = 0 ; i < numData ; i++ ) {
                data[i] = i & 0xFF ;
            }
            spi_mem.programPage(address, data, numData) ;
            data[0] = 0 ;
            while((data[0] & 0x01) != 0x01 ) {
                printf(".") ;
                data[0] = spi_mem.readStatus() ;
                wait(0.01) ;
            }
            printf("\n\r") ;
        } else if (strcmp(cmd, "pe") == 0) {
            spi_mem.writeEnable() ;
            scanf("%X", &address) ;
            spi_mem.pageErase(address) ;
        } else if (strcmp(cmd, "se") == 0) {
            spi_mem.writeEnable() ;
            scanf("%X", &address) ;
            spi_mem.sectorErase(address) ;
        } else if (strcmp(cmd, "dump") == 0) {
            scanf("%X", &address) ;
            dump(address) ;
        } else if (strcmp(cmd, "help") == 0) {
            usage() ;
        } else {
            printf("Unknown command [ %s ]\n\r", cmd) ;
            usage() ;
        }
    }
}
