#include "mbed.h"
#include "MSS.h"
#include "RTC8564.h"

#define RTC8564_I2C_ADDRESS (0x51)

char *dayName[] = {
    "Sunday",
    "Monday",
    "Tuesday",
    "Wednesday",
    "Thursday",
    "Friday",
    "Saturday",
    0
} ;

RTC8564 *rtc = 0 ;

void dumpData(uint8_t data[])
{
    int i ;
    for (i = 0 ; i < 0x10 ; i++ ) {
        printf("%02X ", data[i]) ;
    }
    printf("\n") ;
}

void prompt(char *str)
{
    printf("%s > ", str) ;
    fflush(stdout) ;
}

void setTime(void)
{
    int year, month, day, dayofweek ;
    int hour, minute, second ;
    rtc->stop() ;
    prompt("Enter Year") ; scanf("%d", &year) ;
    rtc->setYears(year-2000) ;

    prompt("Enter Month") ; scanf("%d", &month) ;
    rtc->setMonths(month) ;
    
    prompt("Enter Day") ; scanf("%d", &day) ;
    rtc->setDays(day) ;
    
    prompt("Enter Day of week(0: Sun... 6: Sat)") ;
    scanf("%d", &dayofweek) ;
    rtc->setWeekdays( dayofweek ) ;

    prompt("Enter hour (0..23)") ; scanf("%d", &hour) ;
    rtc->setHours(hour) ;
    
    prompt("Enter min (0..59)") ; scanf("%d", &minute) ;
    rtc->setMinutes( minute ) ;
    
    prompt("Enter sec (0..59)") ;  scanf("%d", &second ) ;
    rtc->setSeconds( second ) ;

    rtc->setMinuteAlarm(0x00) ;
    rtc->setHourAlarm(0x00) ;
    rtc->setDayAlarm(0x00) ;
    rtc->setWeekdayAlarm(0x00) ;
    rtc->setCLKOUTFrequency(0x00) ;
    rtc->setTimerControl(0x00) ;
    rtc->setTimer(0x00) ;
    
    rtc->start() ;
}

void printTime(void)
{
    if (rtc) {
        printf("20%02d/%02d/%02d %s %02d:%02d:%02d\n",
            rtc->getYears(),
            rtc->getMonths(),
            rtc->getDays(),
            dayName[ rtc->getWeekdays() ],
            rtc->getHours(),
            rtc->getMinutes(), 
            rtc->getSeconds()
        ) ;
    }
}

int main() {
    rtc = new RTC8564(PIN_SDA, PIN_SCL, RTC8564_I2C_ADDRESS) ;
    printf("=== test RTC8564 for %s (%s) ===\n",BOARD_NAME, __DATE__) ;
    setTime() ;
    while(1){
        printTime() ;
        wait(1) ;
    }
}
