/** mbed oscilloscope my implementation of a oscillo scope
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * menu.cpp
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include <ILI9341.h>
#include "SPI_STMPE610.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "Arial43x48_numb.h"
#include "vt100.h"
#include "TFTMenu.h"
#include "menu.h"
#include "trig.h"
#include "view.h"
#include "main.h"

void doubleTime(void) 
{
    if (mode == MODE_RUN) {
        timer.detach() ;
    }
    envChanged() ;
    us_interval *= 2 ;
    if (us_interval > MAX_INTERVAL) {
        us_interval = MAX_INTERVAL ;
    }
    printTimeDiv() ;
    if (mode == MODE_RUN) {
        timer.attach_us(&sampleAD, us_interval) ;
    }
}

void halfTime(void)
{
    if (mode == MODE_RUN) {
        timer.detach() ;
    }
    envChanged() ;
    us_interval /= 2 ;
    if (us_interval < MIN_INTERVAL) {
        us_interval = MIN_INTERVAL ;
    }
    printTimeDiv() ;
    if (mode == MODE_RUN) {
        timer.attach_us(&sampleAD, us_interval) ;
    }
}

void doStart(void)
{
    if (mode == MODE_RUN) {
        mode = MODE_STOP ;
        timer.detach() ;
        printMode() ;
    } else {
        mode = MODE_RUN ;
        printMode() ;
        timer.attach_us(&sampleAD, us_interval) ;
    }

}

void doubleAmp(void)
{
}

void halfAmp(void)
{
}

void doTrigger(void)
{
    trig_mode = (trig_mode + 1) % NUM_TRIG_MODE ;
    drawTrigMark() ;
    printTrigMode() ;
}

void doStop(void)
{
    timer.detach() ;
    mode = MODE_STOP ;
    printMode() ;
}

void TrigLevelDown(void)
{
    trig_level -= 0.1 ;
    if (trig_level < 0.0) {
        trig_level = 0.0 ;
    }
    printTrigLevel() ;
}

void TrigLevelUp(void)
{
    trig_level += 0.1 ;
    if (trig_level > vref) {
        trig_level = vref ;
    }
    printTrigLevel() ;
}

void initMenu(void)
{
    numMenu = 0 ;
    menu[numMenu++] = new TFTRadioButton( 20, 190,  60, 220, doStart,   "Run", Blue, White, "Stop", Red, White, true) ;
 //   menu[numMenu++] = new TFTMenuItem(180, 180, 220, 210, doStop,    "Stop",  Red, White) ;
    menu[numMenu++] = new TFTMenuItem( 20, 230,  55, 260, doubleTime, "1/2",  Blue, White) ;
    menu[numMenu++] = new TFTMenuItem(180, 230, 215, 260, halfTime,   "x2",   Blue, White) ;
    menu[numMenu++] = new TFTMenuItem( 20, 270,  60, 300, doTrigger,  "Trig", Green, Black) ;
//    menu[numMenu++] = new TFTMenuItem(170, 260, 190, 290, TrigLevelUp,  "^", Blue, White) ;
//    menu[numMenu++] = new TFTMenuItem(200, 260, 220, 290, TrigLevelDown, "V", Blue, White) ;

}

void drawMenu(void)
{
    for (int i = 0 ; i < numMenu ; i++ ) {
        menu[i]->draw() ;
    }
    printMode() ;
    printTimeDiv() ;
    printTrigMode() ;
}

bool doMenu(uint16_t x, uint16_t y)
{
    bool result = false ;
/*
    if ((x == 0)&&(y ==0)) {
        return 
    }
*/
    for (int i = 0 ; i < numMenu ; i++ ) {
        if (menu[i]->hit(x, y)) {
//            menu[i]->highlight() ;
            menu[i]->doIt() ;
            menu[i]->draw() ;
            result = true ;
            break ;
        }
    }
    return( result ) ;
}