/** mbed oscilloscope my implementation of a oscillo scope
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * view.h
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef _VIEW_H_
#define _VIEW_H_ defined

extern int pane_w ;
extern int pane_h ; // height per channel
extern int head_h ; // header height
extern int foot_h ; // footer height
extern int right_margin  ;
extern int left_margin  ;

void initTFT(void) ;
void eraseChFrame(int ch) ;
void eraseGraphFrames(void) ;
void drawChFrame(int ch) ;
bool inChFrame(int ch, int x, int y) ;
void plotCh_line(int turn, int ch, int index, int color) ;
void drawGraphFrames(void) ;
void drawChart(void) ;
void printMode(void) ;
void printTimeDiv(void) ;
void printTrigMode(void) ;
void printTrigLevel(void) ;
void drawTrigMark(void) ;
void eraseTrigMark(void) ;
#endif /* _VIEW_H_ */