/** mbed oscilloscope my implementation of a oscillo scope
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * trig.h
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/*
 * About the ring buffer and trigger
 *
 * use data memory of memLength as a ring buffer
 * trig_pos: the trigger position on the display 
 * trig_index: the data index where the trigger hit
 * bor: begin of ring_buffer
 * eor: end of ring_buffer (do we really need this?)
 * data_index: the data index of current data sampling
 *
 * Display = absolute memory placement
 *        +-+----------------+--------+-----------+-----------+
 *        |0|                |trig_pos|           |memLength-1|
 *        +-+----------------+--------+-----------+-----------+
 * if trig_pos == trig_index
 *         0
 *        +---+--------------+----------+-----------------+---+
 *        |bor|              |trig_index|                 |eor|
 *        +---+--------------+----------+-----------------+---+
 * if trig_pos > trig_index
 *         0
 *   +---+--------------+----------+-----------------+---+
 *   |bor|              |trig_index|                 |eor|
 *   +---+--------------+----------+-----------------+---+
 * if trig_pos < trig_index
 *         0                                                    0
 *               +---+--------------+----------+-----------------+---+
 *               |bor|              |trig_index|                 |eor|
 *               +---+--------------+----------+-----------------+---+
 * the buffer length = memLength ;
 * status(s)
 * 0: pre_trigger:  for the beginning of sampling, before trig_pos
 * 1: trigger_wait: if check_trigger() move to trigger_hit
 * 2: tigger_hit:   trigger has been hit, sampling data till data_full
 * 3: buffer_full:  stop sampling and wait for the data to be consumed
 */
#ifndef _TRIG_H_
#define _TRIG_H_ defined
#include "mbed.h"

// Trigger modes
#define TRIG_MODE_NONE   0
#define TRIG_MODE_RISE   1
#define TRIG_MODE_FALL   2
#define TRIG_MODE_LEVEL  3
#define NUM_TRIG_MODE    4

// ST: Sampling Status
#define ST_PRE_TRIG      0
#define ST_TRIG_WAIT     1
#define ST_TRIG_HIT      2
#define ST_BUF_FULL      3

// trigger related values
extern int sampling_status ;
extern int trig_mode ;
extern int trig_ch ;
extern int trig_pos ;
extern float trig_level ;
extern uint16_t utrig_level ;
extern int trig_index ; 
extern int post_trig_index ;
extern int post_trig_len ; // length between trig_pos to end of display
extern int trig_level_margin ;
extern int memLength ;

extern char *trig_name[] ;

#endif /* _TRIG_H_ */