/** mbed oscilloscope my implementation of a oscillo scope
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef _MAIN_H_
#define _MAIN_H_ included

#if defined (TARGET_KL25Z) 
#define PIN_SCLK        PTD1
#define PIN_MISO        PTD3 
#define PIN_MOSI        PTD2
#define PIN_CS_TFT      PTD0 
#define PIN_DC_TFT      PTD5 
#define PIN_CS_TSC      PTA13
#define PIN_BL_TFT      PTA12
#define PIN_CS_SD       PTA4 
#define PIN_TSC_INTR    PTC9 /* place holder */
#define PIN_RESET_TFT   PTB10 /* place holder */
#define PIN_ADC_CH0     PTB0
#define PIN_ADC_CH1     PTB2

#elif defined (TARGET_KL46Z)
#define PIN_SCLK        PTD5 
#define PIN_MISO        PTD7 
#define PIN_MOSI        PTD6
#define PIN_CS_TFT      PTD4 
#define PIN_DC_TFT      PTD2 
#define PIN_CS_TSC      PTA13
#define PIN_BL_TFT      PTC9 
#define PIN_CS_SD       PTA4 
#define PIN_TSC_INTR    PTC7 /* place holder */
#define PIN_RESET_TFT   PTC6 /* place holder */
#define PIN_ADC_CH0     PTB0
#define PIN_ADC_CH1     PTB2

#elif defined (TARGET_K64F)
#define PIN_SCLK        PTD1
#define PIN_MISO        PTD3
#define PIN_MOSI        PTD2
#define PIN_CS_TFT      PTD0
#define PIN_DC_TFT      PTC4
// for board rev E or later
#define PIN_CS_TSC      PTC12
// for earlier boards use following line
// #define PIN_CS_TSC      PTA0
#define PIN_BL_TFT      PTC3
#define PIN_CS_SD       PTB23
#define PIN_TSC_INTR    PTC0 /* place holder */
#define PIN_RESET_TFT   PTC9 /* place holder */
#define PIN_ADC_CH0     PTB2
#define PIN_ADC_CH1     PTB10

#elif defined (TARGET_K22F)
#define PIN_SCLK        PTD5
#define PIN_MISO        PTD7
#define PIN_MOSI        PTD6
#define PIN_CS_TFT      PTD4
#define PIN_DC_TFT      PTA1
#define PIN_CS_TSC      PTB19
#define PIN_BL_TFT      PTC6 
#define PIN_CS_SD       PTA4 
#define PIN_TSC_INTR    PTC7 /* place holder */
#define PIN_RESET_TFT   PTC9 /* place holder */
#define PIN_ADC_CH0     PTB0
#define PIN_ADC_CH1     PTC1

#elif defined (TARGET_NUCLEO_F411RE)
#define PIN_SCLK        PA_5
#define PIN_MISO        PA_6
#define PIN_MOSI        PA_7
#define PIN_CS_TFT      PB_6
#define PIN_DC_TFT      PC_7
#define PIN_CS_TSC      PA_9
#define PIN_BL_TFT      PA_8
#define PIN_CS_SD       PB_5
#define PIN_TSC_INTR    PA_8 /* place holder */
#define PIN_RESET_TFT   PA_13 /* place holder */
#define PIN_ADC_CH0     PA_0
#define PIN_ADC_CH1     PA_4

#elif defined (TARGET_K20D50M)
#define PIN_SCLK        PTD1
#define PIN_MISO        PTD3
#define PIN_MOSI        PTD2
#define PIN_CS_TFT      PTC2
#define PIN_DC_TFT      PTA2 
#define PIN_CS_TSC      PTA12
#define PIN_BL_TFT      PTC4 
#define PIN_CS_SD       PTC8 
#define PIN_TSC_INTR    PTA4 /* place holder */
#define PIN_RESET_TFT   PTC7 /* place holder */
#define PIN_ADC_CH0     PTC0
#define PIN_ADC_CH1     PTD6

#elif defined (TARGET_RZ_A1H)
#define PIN_SCLK        P10_12
#define PIN_MISO        P10_15
#define PIN_MOSI        P10_14
#define PIN_CS_TFT      P10_13
#define PIN_DC_TFT      P8_14 
#define PIN_CS_TSC      P8_15
#define PIN_BL_TFT      P8_11
#define PIN_CS_SD       P4_5 
#define PIN_TSC_INTR    P2_9 /* place holder */
#define PIN_RESET_TFT   P2_10 /* place holder */
#define PIN_ADC_CH0     P1_8
#define PIN_ADC_CH1     P1_10
#elif defined (TARGET_MAX32600MBED)
/* I2C */
#define PIN_SCL  P2_7
#define PIN_SDA  P2_6
/* SPI */
#define PIN_SCLK  P2_0
#define PIN_MISO P2_2
#define PIN_MOSI P2_1
#define PIN_CS0  P2_3
/* Interrupt */
#define PIN_INT0 P2_4
#define PIN_INT1 P2_5
#define PIN_INT2 P1_7
#define PIN_INT3 P1_6
#define PIN_INT4 P1_5
#define PIN_INT5 P1_4
/* Analog In */
#define PIN_AN0  AIN_0P
#define PIN_AN1  AIN_1P
#define PIN_AN2  AIN_2P
#define PIN_AN3  AIN_3P
#define PIN_AN4  AIN_4P
#define PIN_AN5  AIN_5P
#define BOARD_NAME "MAX32600MBED"

#define PIN_CS_TFT      P2_3 // D10 PTD0 
#define PIN_DC_TFT      P2_4 // D9  PTD5 
#define PIN_CS_TSC      P2_5 // D8  PTA13
#define PIN_BL_TFT      P1_7 // D7   PTC9 
#define PIN_CS_SD       P1_4 // D4   PTA4 
#define PIN_TSC_INTR    P5_4 // PTC9 /* place holder */
#define PIN_RESET_TFT   P5_5 /// PTB10 /* place holder */
#define PIN_ADC_CH0     AIN_0P // A0 PTB0
#define PIN_ADC_CH1     AIN_2P // A2 PTB2

#else
 #error TARGET NOT DEFINED
#define PIN_SCLK        D13 
#define PIN_MISO        D12 
#define PIN_MOSI        D11
#define PIN_CS_TFT      D10 
#define PIN_DC_TFT      D9 
#define PIN_CS_TSC      D8
#define PIN_BL_TFT      D7 
#define PIN_CS_SD       D4 
#define PIN_TSC_INTR    D5-inside /* place holder */
#define PIN_RESET_TFT   D4-inside /* place holder */
#define PIN_ADC_CH0     A0
#define PIN_ADC_CH1     A2

#endif

#define CHART_LEN    198

// NOTE: in case MIN_INTERVAL is too small
// the program hangs during ADC and timer interrupt
#if defined (TARGET_MAX32600MBED)
#define MIN_INTERVAL   60
#else
#define MIN_INTERVAL   30
#endif
#define MAX_INTERVAL   20000
#define NUM_MAX_MENU   20
#define NUM_MAX_ANALOG_CH 2
#define MODE_RUN 1 
#define MODE_STOP 0

extern vt100 tty ;
extern AnalogIn *ach[] ;
extern Ticker timer ;

extern DigitalOut backlight ;
extern ILI9341 TFT ;
extern SPI_STMPE610 TSC ;
extern TFTMenuItem *menu[] ;
extern int numMenu ;

extern float vref ; // input range 0 - 3.3V

extern uint16_t udata[2][NUM_MAX_ANALOG_CH][CHART_LEN] ;
extern int data_index ;
extern uint16_t bor[2] ; // begin of ring buffer

extern int numAnalogIn  ;
extern int memLength  ;
extern int us_interval ; // 20us = 50KHz
extern bool frame_full  ;
extern int page ; // 
extern int prev_page  ;
extern int mode  ;

float u2v(uint16_t uvalue) ;
uint16_t v2u(float voltage) ;
float u2f(uint16_t value) ;

void initADC(void) ;
void envChanged(void) ;
bool checkTrigger(void) ;
void sampleAD(void) ;
#endif /* _MAIN_H_ */