/** mbed orgel Very very simple orgel using pwm
 * Copyright (c) 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "tone.h"
#include "tune.h"
 
/*
 * note[], num_notes, tempo are defined in tune.h
 */ 
extern unsigned char note[] ;
extern int num_notes ;
extern float tempo ;

PwmOut out1(PTD4) ; // D2 

void play_tune(void)
{
    float note_length = 60.0 / (tempo * 4.0) ;
    
    out1.write(0.0) ; // stop sound
    for (int i = 0 ; i < num_notes ; i++) {
            if (note[i] > 0) { // tone
                out1.period_us(tone_us[note[i]]) ;
                out1.write(0.5) ;
            } else { // rest
                out1.write(0.0) ; 
            }
            wait(note_length) ;
    }
    out1.write(0.0) ;
}

int main() {
    while(1) {
        play_tune() ;
        wait(1) ;
    }
}
