/**
 * matrix key scan program
 *
 * @note assuming key pad of 16 keys
 * @note 4 x 4 matrix scan
 */
#include "mbed.h"

#if defined (TARGET_KL25Z)
#define COL0 PTC7
#define COL1 PTC0
#define COL2 PTC3
#define COL3 PTC4
#define ROW0 PTC5
#define ROW1 PTC6
#define ROW2 PTC10
#define ROW3 PTC11
#endif

#define NUM_COL 4
#define NUM_ROW 4
#define NUM_KEY (NUM_COL * NUM_ROW)

int key[ NUM_KEY ] = {
    0, 0, 0, 0,
    0, 0, 0, 0,
    0, 0, 0, 0,
    0, 0, 0, 0
} ;

#if 0 
/* Sengoku 4x4 keypad */
unsigned char key_char[NUM_KEY] = {
    '1', '2', '3', 'A',
    '4', '5', '6', 'B',
    '7', '8', '9', 'C',
    '*', '0', '#', 'D'
} ; 
#endif /* Sengoku 4x4 keypad */
#if 1
/* Aitendo HC-54375 */
unsigned char key_char[NUM_KEY] = {
    'C', 'D', 'E', 'F',
    '9', '0', 'A', 'B',
    '5', '6', '7', '8',
    '1', '2', '3', '4'
} ;
#endif /* Aitendo HC-54375 */

DigitalIn  *col[NUM_COL] ;
DigitalOut *row[NUM_ROW] ;

void init_hardware(void)
{
    col[3] = new DigitalIn(COL3, PullUp) ;
    col[2] = new DigitalIn(COL2, PullUp) ;
    col[1] = new DigitalIn(COL1, PullUp) ;
    col[0] = new DigitalIn(COL0, PullUp) ;

    row[3] = new DigitalOut(ROW3, 1) ;
    row[2] = new DigitalOut(ROW2, 1) ;
    row[1] = new DigitalOut(ROW1, 1) ;
    row[0] = new DigitalOut(ROW0, 1) ;
}

int scan_key(int key[])
{
    int r, c ;
    int count = 0 ;

    for (r = 0 ; r < NUM_ROW ; r++ ) {
        row[r]->write(0) ;
        for (c = 0 ; c < NUM_COL ; c++ ) {
            if (col[c]->read() == 0) {
                key[r * NUM_COL + c] = 1 ;
                count++ ;
            } else {
                key[r * NUM_COL + c] = 0 ;
            }
        }
        row[r]->write(1)  ;
    }
    return(count) ;
}

void print_key(int key[])
{
    int i ;
    for (i = 0 ; i < NUM_KEY ; i++ ) {
        if (key[i]) {
            printf("%c", key_char[i]) ;
        }
    }
}
    
int main() {
    int count ;
    
    init_hardware() ;
    
    printf("\n=== Matrix Key Test %s ===\n", __DATE__) ;
    
    while(1) {
        count = scan_key(key) ;
        if (count) {
            print_key(key) ;
            fflush(stdout) ;
            wait(0.2) ;
        }
        wait(0.1) ;
    }
}
