/** triwave class
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "triwave.h"

triwave::triwave(float v, int f, int d, int p) : sqrwave(v, f, d, p) 
{
    _name = "tri" ; 
}

triwave::~triwave(void) { }

int triwave::value(void)
{
    int result = 0 ;
    if (_cycle == 0) {
        if (_duty == 100) {
            result = _amp ;
        } else {
            result = 0 ;
        }
    } else if (_duty == 100) { // saw wave
        result = _amp * _pos / _cycle ;
    } else if (_duty == 0) { // reversed saw wave
        result = _amp * (_cycle - _pos) / _cycle ;
    } else { // tri wave
        if (_pos < (int)((_duty * _cycle)/100)) {
            result = _amp * _pos / ((_duty * _cycle) / 100) ;
        } else {
            result = _amp - _amp * (_pos - (_duty * _cycle)/100) / ((_cycle * (100 - _duty))/100) ;
        }
    }
    return( result ) ;
}
