/** sinwave class
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "sinwave.h"
#include "sin_table.h"

sinwave::sinwave(float v, int f, int d, int p) : wave(v, f, d, p) 
{
    _name = "sin" ; 
}

sinwave::~sinwave(void) {}

void sinwave::duty(int newvalue)
{
    _duty = newvalue ;
}

int sinwave::duty(void) 
{
    return( 50 ) ;
}

int sinwave::value(void)
{
    int result = 0 ;
    
    if (_phase < 90) {
        result = _amp * (SIN_ZERO + sin_table[ _phase * NUM_SIN_TABLE / 90 ])/0xFFFF ;
    } else if (_phase < 180) {
        result = _amp * (SIN_ZERO + sin_table[(180 - _phase) * NUM_SIN_TABLE / 90])/0xFFFF ;
    } else if (_phase < 270) {
        result = _amp * (SIN_ZERO - sin_table[(_phase - 180) * NUM_SIN_TABLE / 90])/0xFFFF ;
    } else if (_phase < 360) {
        result = _amp * (SIN_ZERO - sin_table[(360 - _phase) * NUM_SIN_TABLE / 90])/0xFFFF ;
    }
    
    return( result ) ;
}