/** sawwave class
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "sawwave.h"

sawwave::sawwave(float v, int f, int d, int p) : wave(v, f, d, p) 
{
    _name = "saw" ; 
}

sawwave::~sawwave(void) { }

void sawwave::duty(int newvalue)
{
    _duty = newvalue ;
}

int sawwave::duty(void) 
{
    return( 100 ) ;
}

int sawwave::value(void)
{
    int result = 0 ;
    if (_cycle != 0) {
        result = _amp * _pos / _cycle ;
    }
    return( result ) ;
}
