/** sinwave class
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
 /** The sin_table.h was generated with the following c code
 * @code
 * #include <stdio.h>
 * #include <math.h>
 *
 * int main(int argc, char *argv[])
 * {
 *    long i ;
 *    double value ;
 *    double pi = 3.14159265359 ;
 *
 *    printf("#ifndef _SIN_TABLE_H_\n") ;
 *    printf("#define _SIN_TABLE_H_\n") ;
 *    printf("#define SIN_ZERO 0x8000\n") ;
 *    printf("#define NUM_SIN_TABLE 2500\n") ;
 *    printf("unsigned short sin_table[] = {\n") ;
 *    for (i = 0 ; i <= 2500 ; i++) {
 *        value = sin(pi * i / 5000.0) ;
 *        printf("0x%04X,", (int)((0x07FFF * value) + 0.5)) ;
 *        if (((i+1) % 0x8) == 0) {
 *           printf("\n") ;
 *        }
 *    }
 *    printf("} ;\n") ;
 *    printf("#endif\n") ;
 * }
 * @endcode
 */
#ifndef _SIN_WAVE_H_
#define _SIN_WAVE_H_ included
#include "wave.h"

/** sinwave sine wave class
 */
class sinwave : public wave {
public:
/** constructor
 *
 * @param float v amplitude in voltage (0.0 ~ 3.28V for FRDM-KL25Z)
 * @param int f frequency in Hz (1 ~ 10000Hz)
 * @param int d duty, ignored for sinwave
 * @param int p phase in degree (0 ~ 359 degree)
 * @returns sinwave class instance
 */
sinwave(float v, int f, int d = 50, int p = 0) ;

/** destructor
 */
~sinwave(void) ;

/** mutator for duty (ignored for sin)
 */
virtual void duty(int newvalue) ;

/** inspector for duty always returns 50 */
virtual int duty(void) ;

/** inspector for the value at _pos
 *
 * @returns int value at current position
 */
virtual int value(void) ;   //returns current value

} ;

#endif /* _SIN_WAVE_H_ */
