/** sqrwave class
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef _SQR_WAVE_H_
#define _SQR_WAVE_H_ included
#include "wave.h"

/** sqrwave square wave class
 */
class sqrwave : public wave {
public:
/** constructor
 *
 * @param float v amplitude in voltage (0.0 ~ 3.28V for FRDM-KL25Z)
 * @param int f frequency in Hz (1 ~ 10000Hz)
 * @param int d duty in percent (0 ~ 100%) 0% for DC 0V, 100% for DC Vref volt
 * @param int p phase in degree (0 ~ 359 degree)
 * @returns sqrwave class instance
 */
sqrwave(float v, int f, int d = 50, int p = 0);

/** destructor */
~sqrwave(void) ;

/** inspector for the value at _pos
 *
 * @returns int value at current position
 */
virtual int value(void) ;           // returns current value

protected:

private:
} ;

#endif /* _SQR_WAVE_H_ */