/** sawwave class
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
 /**
  * It was after I had written this class when I noticed that
  * triwave with duty=100 is actually sawwave.
  * So besically this class is not necessary, but for the time being
  * it's here anyway.
  */
  
#ifndef _SAW_WAVE_H_
#define _SAW_WAVE_H_ included
#include "wave.h"

/** sawwave class
 */
class sawwave : public  wave {
public:

/** constructor
 *
 * @param float v amplitude in voltage (0.0 ~ 3.28V for FRDM-KL25Z)
 * @param int f frequency in Hz (1 ~ 10000Hz)
 * @param int d duty, ignored for sawwave
 * @param int p phase in degree (0 ~ 359 degree)
 * @returns sawwave class instance
 */
sawwave(float v, int f, int d = 50, int p = 0) ;

/** destructor
 */
~sawwave(void) ;

/** mutator for duty (ignored for sawwave)
 */
virtual void duty(int newvalue) ;

/** inspector for duty always returns 100 */
virtual int duty(void) ;

/** inspector for the value at _pos
 *
 * @returns int value at current position
 */
virtual int value(void) ;   // return current value

protected:

private:
} ;

#endif /* _SAW_WAVE_H_ */