/** triwave class
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef _TRI_WAVE_H_
#define _TRI_WAVE_H_ included
#include "sqrwave.h"

/** triwave triangle wave class
 */
class triwave : public sqrwave {
public:
/** constructor
 *
 * @param float v amplitude in voltage (0.0 ~ 3.28V for FRDM-KL25Z)
 * @param int f frequency in Hz (1 ~ 10000Hz)
 * @param int d duty of rising ramp in percent (0 ~ 100%) 0% for saw wave, 100% for reversed saw wave
 * @param int p phase in degree (0 ~ 359 degree)
 * @returns sqrwave class instance
 */
triwave(float v, int c, int d = 50, int p = 0) ;

/** destructor */
~triwave(void) ;

/** inspector for the value at _pos
 *
 * @returns int value at current position
 */
virtual int value(void) ;       // return s current value
} ;

#endif /* _TRI_WAVE_H_ */
