#include "mbed.h"
#include "VCNL4010.h"

/* I2C 7bit address is 0x13 */
/* Register Definitions */
#define REG_COMMAND                  0x80
#define REG_PRODUCT_ID               0x81
#define REG_PROXIMITY_RATE           0x82
#define REG_IR_LED_CURRENT           0x83
#define REG_AMBIENT_LIGHT_PARAMETER  0x84
#define REG_AMBIENT_LIGHT_RESULT_MSB 0x85
#define REG_AMBIENT_LIGHT_RESULT_LSB 0x86
#define REG_PROXIMITY_RESULT_MSB     0x87
#define REG_PROXIMITY_RESULT_LSB     0x88
#define REG_INTERRUPT_CONTROL        0x89
#define REG_LOW_THRESHOLD_MSB        0x8A
#define REG_LOW_THRESHOLD_LSB        0x8B
#define REG_HIGH_THRESHOLD_MSB       0x8C
#define REG_HIGH_THRESHOLD_LSB       0x8D
#define REG_INTERRUPT_STATUS         0x8E
#define REG_PROXIMITY_MOD_TIMING     0x8F

/* Bits in Register */
/* COMMAND REGISTER (0x80) */

/* mandatory functions */
VCNL4010::VCNL4010(PinName sda, PinName scl, int addr): m_i2c(sda, scl), m_addr(addr<<1) {
    // activate the peripheral
}

VCNL4010::~VCNL4010()
{
}

void VCNL4010::readRegs(int addr, uint8_t * data, int len) {
    char t[1] = {addr};
    m_i2c.write(m_addr, t, 1, true);
    m_i2c.read(m_addr, (char *)data, len);
}

void VCNL4010::writeRegs(uint8_t * data, int len) {
    m_i2c.write(m_addr, (char *)data, len);
}

/* device specific member functions */
uint8_t  VCNL4010::getCommandReg(void) 
{
    uint8_t cmd ;
    readRegs(REG_COMMAND, &cmd, 1) ;
    return( cmd ) ;
}

void     VCNL4010::setCommandReg(uint8_t cmd) 
{
    uint8_t data[2] ;
    data[0] = REG_COMMAND ;
    data[1] = cmd ;
    writeRegs(data, 2) ;
}

uint8_t  VCNL4010::getProductID(void) 
{
    uint8_t id ;
    readRegs(REG_PRODUCT_ID, &id, 1) ;
    return( id ) ;
}

uint8_t  VCNL4010::getProxRate(void) 
{
    uint8_t rate ;
    readRegs(REG_PROXIMITY_RATE, &rate, 1) ;
    return( rate ) ;
}

void     VCNL4010::setProxRate(uint8_t rate) 
{
    uint8_t data[2] ;
    data[0] = REG_PROXIMITY_RATE ;
    data[1] = rate ;
    writeRegs(data, 2) ;
}

uint8_t  VCNL4010::getIrLedCurrent(void) 
{
    uint8_t IrLedCur ;
    readRegs(REG_IR_LED_CURRENT, &IrLedCur, 1) ;
    return( IrLedCur ) ;
}

void     VCNL4010::setIrLedCurrent(uint8_t IrLedCur) 
{
    uint8_t data[2] ;
    data[0] = REG_IR_LED_CURRENT ;
    data[1] = IrLedCur ;
    writeRegs(data, 2) ;
}

uint8_t  VCNL4010::getAlsParam(void) 
{
    uint8_t param ;
    readRegs(REG_AMBIENT_LIGHT_PARAMETER, &param, 1) ;
    return( param ) ;
}

void     VCNL4010::setAlsParam(uint8_t param) 
{
    uint8_t data[2] ;
    data[0] = REG_AMBIENT_LIGHT_PARAMETER ;
    data[1] = param ;
    writeRegs(data, 2) ;
}

uint16_t VCNL4010::getAls(void) 
{
    uint16_t als ;
    uint8_t data[2] ;
    readRegs(REG_AMBIENT_LIGHT_RESULT_MSB, data, 2) ;
    als = (data[0] << 8) | data[1] ;
    return( als ) ;
}

uint16_t VCNL4010::getProx(void) 
{
    uint16_t prox ;
    uint8_t data[2] ;
    readRegs(REG_PROXIMITY_RESULT_MSB, data, 2) ;
    prox = (data[0] << 8) | data[1] ;
    return( prox ) ;
}

uint8_t  VCNL4010::getIntCtrl(void) 
{
    uint8_t ctrl ;
    readRegs(REG_INTERRUPT_CONTROL, &ctrl, 1) ;
    return( ctrl ) ;
}

void     VCNL4010::setIntCtrl(uint8_t ctrl) 
{
    uint8_t data[2] ;
    data[0] = REG_INTERRUPT_CONTROL ;
    data[1] = ctrl ;
    writeRegs(data, 2) ;
}

uint16_t VCNL4010::getLowThreshold(void) 
{
    uint16_t thr ;
    uint8_t data[2] ;
    readRegs(REG_LOW_THRESHOLD_MSB, data, 2) ;
    thr = (data[0] << 8) | data[1] ;
    return( thr ) ;
}

void     VCNL4010::setLowThreshold(uint16_t thr) 
{
    uint8_t data[3] ;
    data[0] = REG_LOW_THRESHOLD_MSB ;
    data[1] = (thr >> 8) & 0xFF ;
    data[2] = thr & 0xFF ;
    writeRegs(data, 3) ;
}

uint16_t VCNL4010::getHighThreshold(void) 
{
    uint16_t thr ;
    uint8_t data[2] ;
    readRegs(REG_HIGH_THRESHOLD_MSB, data, 2) ;
    thr = (data[0] << 8) | data[1] ;
    return( thr ) ;
}

void     VCNL4010::setHighThreshold(uint16_t thr) 
{
    uint8_t data[3] ;
    data[0] = REG_HIGH_THRESHOLD_MSB ;
    data[1] = (thr >> 8) & 0xFF ;
    data[2] = thr & 0xFF ;
    writeRegs(data, 3) ;
}

uint8_t  VCNL4010::getIntStatus(void) 
{
    uint8_t status ;
    readRegs(REG_INTERRUPT_STATUS, &status, 1) ;
    return( status ) ;
}

void     VCNL4010::setIntStatus(uint8_t status) 
{
    uint8_t data[2] ;
    data[0] = REG_INTERRUPT_STATUS ;
    data[1] = status ;
    writeRegs(data, 2) ;
}

uint8_t  VCNL4010::getProxModTiming(void) 
{
    uint8_t timing ;
    readRegs(REG_PROXIMITY_MOD_TIMING, &timing, 1) ;
    return( timing ) ;
}

void     VCNL4010::setProxModTiming(uint8_t timing) 
{
    uint8_t data[2] ;
    data[0] = REG_PROXIMITY_MOD_TIMING ;
    data[1] = timing ;
    writeRegs(data, 2) ;
}
