/** Tokei
 * "Tokei" means a clock or watch in Japanese
 */
 
#include "mbed.h"
#include "SPI_TFT_ILI9341.h"
#include "SPI_STMPE610.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

#define PIN_MOSI        PTD2
#define PIN_MISO        PTD3 
#define PIN_SCLK        PTD1 
#define PIN_CS_TFT      PTD0 
#define PIN_DC_TFT      PTD5 
#define PIN_BL_TFT      PTC9 
#define PIN_CS_SD       PTA4 
#define PIN_CS_TSC      PTA13
#define PIN_TSC_INTR    PTC9

// return values for the adjust menu
#define AM_CANCEL 0x00
#define AM_OK     0x01
#define AM_UP     0x02
#define AM_DOWN   0x04
#define AM_NG     0xFF

SPI_TFT_ILI9341 TFT(PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TFT, PIN_BL_TFT, PIN_DC_TFT) ;
SPI_STMPE610 TSC(PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TSC) ;

DigitalOut backlight(PTA12) ;

Ticker timer ;
bool ticked = false ;
int hour = 14 ;
int min = 40 ;
int sec = 0 ;
char time_str[32] ;

void initTFT(void)
{
    //Configure the display driver
    TFT.background(Black);
    TFT.foreground(White);
    wait(0.01) ;
    TFT.cls();
}
    
void drawAdjustMenu(void)
{
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(180, 100) ;
    TFT.foreground(Yellow) ;
    TFT.printf("UP") ;
    TFT.locate(180, 160) ;
    TFT.foreground(Yellow) ;
    TFT.printf("DOWN") ;
    TFT.locate(20, 280) ;
    TFT.foreground(Blue) ;
    TFT.printf("CANCEL") ;
    TFT.locate(200, 280) ;
    TFT.foreground(Green) ;
    TFT.printf("OK") ;
}

void draw_tmp_value(uint16_t value)
{
    char str[8] ;
    TFT.foreground(White) ;
    TFT.set_font((unsigned char*) Arial28x28);
    sprintf(str, " %02d ", value) ;
    TFT.locate(80, 120) ;
    TFT.printf(str) ;
}

int getAdjustMenu(void)
{
    uint16_t x, y, z ;
    int result = AM_NG ;
    if ( TSC.getPoint(&x, &y, &z)) {
        if ((180 <= x)&&(x < 240)&&(80 <= y)&&(y < 120)) { // up
            result = AM_UP ;
        } else if ((180 <= x)&&(x < 240)&&(140 <= y)&&(y < 180)) { // down
            result = AM_DOWN ;
        } else if ((20 <= x)&&(x < 60)&&(260 <= y)) { // cancel
            result = AM_CANCEL ;
        } else if ((200 <= x)&&(x < 240)&&(260 <= y)) { // OK
            result = AM_OK ;
        }
    }
    return(result) ;
}

void set_hour(void)
{
    bool selected = false ;
    int16_t tmp_hour, prev_value = -1 ;
    tmp_hour = hour ;
    TFT.cls() ;
    TFT.foreground(White) ;
    TFT.set_font((unsigned char*) Arial28x28);
    TFT.locate(60, 50) ;
    TFT.printf("Set Hour") ;
     
    while(!selected) {
        if (tmp_hour != prev_value) {
            draw_tmp_value(tmp_hour) ;   
            drawAdjustMenu() ;   
            prev_value = tmp_hour ;    
        }

        switch(getAdjustMenu()) {
        case AM_CANCEL:
            selected = true ;
            break ;
        case AM_OK:
            hour = tmp_hour ;
            selected = true ;
            break ;
        case AM_UP:
            tmp_hour++ ;
            if (tmp_hour > 23) {
                 tmp_hour = 0 ;
            }
            break ;
        case AM_DOWN:
            tmp_hour-- ;
            if (tmp_hour < 0) {
                tmp_hour = 0 ;
            }
        default:
            break ;
        }
        wait(0.1) ;
    }    
    TFT.cls() ;
}

void set_min(void)
{
    bool selected = false ;
    int16_t tmp_min, prev_value = -1 ;
    tmp_min = min ;
    TFT.cls() ;
    TFT.set_font((unsigned char*) Arial28x28);
    TFT.foreground(White) ;
    TFT.locate(60, 50) ;
    TFT.printf("Set Min") ;

    while(!selected) {
        if (tmp_min != prev_value) {
            draw_tmp_value(tmp_min) ;
            drawAdjustMenu() ;   
            prev_value = tmp_min ;   
        }
       
        switch(getAdjustMenu()) {
        case AM_CANCEL:
            selected = true ;
            break ;
        case AM_OK:
            min = tmp_min ;
            selected = true ;
            break ;
        case AM_UP:
            tmp_min++ ;
            if (tmp_min > 59) {
                 tmp_min = 0 ;
            }
            break ;
        case AM_DOWN:
            tmp_min-- ;
            if (tmp_min < 0) {
                tmp_min = 0 ;
            }
        default:
            break ;
        }
        wait(0.1) ;
    }    
    TFT.cls() ;
}

void set_sec(void)
{
    bool selected = false ;
    int16_t tmp_sec, prev_value = -1 ;
    tmp_sec = sec ;
    TFT.cls() ;
    TFT.foreground(White) ;
    TFT.set_font((unsigned char*) Arial28x28);
    TFT.locate(60, 50) ;
    TFT.printf("Set Sec") ;

    while(!selected) {
        if (tmp_sec != prev_value) {
            draw_tmp_value(tmp_sec) ; 
            drawAdjustMenu() ;    
            prev_value = tmp_sec ;
        }

        switch(getAdjustMenu()) {
        case AM_CANCEL:
            selected = true ;
            break ;
        case AM_OK:
            sec = tmp_sec ;
            selected = true ;
            break ;
        case AM_UP:
            tmp_sec++ ;
            if (tmp_sec > 59) {
                 tmp_sec = 0 ;
            }
            break ;
        case AM_DOWN:
            tmp_sec-- ;
            if (tmp_sec < 0) {
                tmp_sec = 0 ;
            }
        default:
            break ;
        }
        wait(0.2) ;
    }   
    TFT.cls() ;
}

void set_time(void)
{
    set_hour() ;
    set_min() ;
    set_sec() ;
}

void display_time(void)
{
    TFT.set_font((unsigned char*) Arial28x28);
    TFT.foreground(White) ;
    sprintf(time_str, " %02d:%02d:%02d ",hour,min,sec) ;
    TFT.locate(50, 100) ;
    wait(0.01) ;
    TFT.printf(time_str) ;
    wait(0.01) ;
}

void tick_time(void) 
{
    sec++ ;
    if (sec > 59) {
        min++ ;
        sec = sec % 60 ;
    }
    if (min > 59) {
        hour++ ;
        min = min % 60 ;
    }
    if (hour > 23) {
        hour = hour % 24 ;
    }
    ticked = true ;
}

void draw_adjust_str(void)
{
    TFT.set_font((unsigned char*) Arial12x12) ;
    TFT.foreground(Blue) ;
    TFT.locate(180, 280) ;
    TFT.printf("adjust") ;
}

int main()
{
    uint16_t x, y ;
    
    initTFT() ;
    timer.attach(&tick_time, 1) ;
    backlight = 1 ;
    set_time() ;
    draw_adjust_str() ;
 
    for(;;) {
        if (ticked) {
            display_time() ;
            ticked = false ;
        }
        
        if ( TSC.getPoint(&x, &y)) {
            if ((180 < x)&&(260 < y)) {
                set_time() ;
                draw_adjust_str() ;
            }
        }       
    }
}
