/** TS_Eyes TSI sample program using Adafruit 2.8" TFT with Touch
 *
 * @note Just like the good old X11 eyes
 * @note this program stares at the point where
 * @note the TSI sensor of FRDM is being touched.
 * @note By touching the right most side of the sensor
 * @note program exits the staring loop and pretend to sleep.
 * @note Then touching the TFT starts the staring loop again.
 */
 
 /* 
  * Note: This program is derived from the SeeeStudioTFTv2 program.
  * Although both program share same ILI9341 TFT driver,
  * the touch sensor was not same with the Display I purchased from Akizuki.
  * http://akizukidenshi.com/catalog/g/gM-07747/
  * The touch sensor on the display is STMPE610,
  * so I hacked the minimum spi driver for it (polling mode only).
  */

#include "mbed.h"
#include "TSISensor.h"
#include "SPI_TFT_ILI9341.h"
#include "SPI_STMPE610.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

#define PIN_MOSI        PTD2
#define PIN_MISO        PTD3 
#define PIN_SCLK        PTD1 
#define PIN_CS_TFT      PTD0 
#define PIN_DC_TFT      PTD5 
#define PIN_BL_TFT      PTC9 
#define PIN_CS_SD       PTA4 
#define PIN_CS_TSC      PTA13
#define PIN_TSC_INTR    PTC9

TSISensor tsi;

SPI_TFT_ILI9341 TFT(PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TFT, PIN_BL_TFT, PIN_DC_TFT) ;
SPI_STMPE610 TSC(PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TSC) ;

DigitalOut backlight(PTA12) ;

void initTFT(void)
{
    //Configure the display driver
    TFT.background(Black);
    TFT.foreground(White);
    wait(0.01) ;
    TFT.cls();
}

void moveEyes(void)
{
    int dx, px ;
    float delta = 0.0 ;
    dx = 0 ;
    px = 0 ;
    backlight = 0 ;
    TFT.background(Black);
    wait(0.1) ;
    TFT.foreground(White);
    wait(0.1) ;
    TFT.cls() ;
    wait(0.1) ;

    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Blue) ;
    TFT.locate(60, 10) ;
    TFT.printf("<< TS Eyes >>") ;
    TFT.locate(30, 280) ;
    TFT.printf("Use FRDM touch slider") ;
    TFT.locate(30, 300) ;
    TFT.printf("Touch right edge to end") ;
    
    TFT.fillcircle(120, 160, 100, Green) ;
    TFT.fillcircle(60, 160, 50, Black) ;
    TFT.fillcircle(60, 160, 45, White) ;
    TFT.fillcircle(180, 160, 50, Black) ;
    TFT.fillcircle(180, 160, 45, White) ;
    TFT.fillcircle(60, 160, 5, Black) ;
    TFT.fillcircle(180, 160, 5, Black) ;
    backlight = 1 ;

    while(dx < 38) {
      delta = (80.0 * (tsi.readPercentage()-0.5)) ;
      dx = (int)(delta + 0.5) ;
      TFT.fillcircle(60+px, 160, 5, White) ;
      TFT.fillcircle(180+px, 160, 5, White) ;
      TFT.fillcircle(60+dx, 160, 5, Black) ;
      TFT.fillcircle(180+dx, 160, 5, Black) ;
      px = dx ;
      wait(0.1) ;
    }
    TFT.fillcircle(60+px, 160, 5, White) ;
    TFT.fillcircle(180+px, 160, 5, White) ;
    TFT.line(15, 160, 105, 160, Black) ;
    TFT.line(135, 160, 225, 160, Black) ;
    TFT.locate(30, 280) ;
    TFT.printf("    Sleeping ... zzz     ") ;
    TFT.locate(20, 300) ;
    TFT.foreground(Yellow) ;
    TFT.printf("  Touch TFT to wake up") ;
}
    
int main()
{
    uint16_t x, y, z ;
    bool awake = true ;
    
    initTFT() ;
    
    for(;;) {

        if (awake) {
            moveEyes() ;
            awake = false ;
        }
        
        if ( TSC.getRAWPoint(&x, &y, &z)) {
            awake = true ;
        }
        
    }
}
