#include "mbed.h"
#include "TSISensor.h"

/** TSI_Cat
 * Test program for SG-90
 * PWM = Orange : D10 (PTD0)
 * Vcc = Red(+) : 5V
 * GND = Brown(-) : GND
 *
 * PWM Period : 20ms (50Hz)
 * Duty Cycle : 1 - 2 ms
 * Note: when I set pulsewidth from 1000us to 2000us
 * the servo did not move -90degree to 90degree
 * so I chanced the value from 500us to 3500us
 * by watching the movement.
 */

TSISensor tsi ; 
PwmOut pwm(PTD0) ; // D10

int main() {
    float tsi_value ;
    pwm.period_ms(20) ; // 20ms period
    
    while(1) {
        tsi_value = tsi.readPercentage() ;
        pwm.pulsewidth_us(500+ 3500*(tsi_value)) ;
        wait(0.01) ;
    }
}
