/* mbed main.cpp to test adafruit 2.8" TFT LCD shiled w Touchscreen
 * Copyright (c) 2014 Motoo Tanaka @ Design Methodology Lab
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
 /* 
  * Note: This program is derived from the SeeeStudioTFTv2 program.
  * Although both program share same ILI9341 TFT driver,
  * the touch sensor was not same with the Display I purchased from Akizuki.
  * http://akizukidenshi.com/catalog/g/gM-07747/
  * The touch sensor on the display is STMPE610,
  * so I hacked the minimum spi driver for it (polling mode only).
  */

#include "mbed.h"
#include "MMA8451Q.h"
#include "TSISensor.h"
#include <math.h>
#include "ILI9341.h"
#include "SPI_STMPE610.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "Arial43x48_numb.h"


#define PIN_XP          PTB3
#define PIN_XM          PTB1
#define PIN_YP          PTB2
#define PIN_YM          PTB0
#define PIN_MOSI        PTD2
#define PIN_MISO        PTD3 
#define PIN_SCLK        PTD1 
#define PIN_CS_TFT      PTD0 
#define PIN_DC_TFT      PTD5 
#define PIN_BL_TFT      PTC9 
#define PIN_CS_SD       PTA4 
#define PIN_CS_TSC      PTA13
#define PIN_TSC_INTR    PTC9
#define PIN_RESET_TFT   PTB10

#define MMA8451_I2C_ADDRESS (0x1d<<1)
MMA8451Q *acc = 0 ;
TSISensor tsi;

DigitalOut backlight(PTA12) ;
ILI9341 TFT(SPI_8, 10000000, 
    PIN_MOSI, PIN_MISO,  PIN_SCLK, 
    PIN_CS_TFT, PIN_RESET_TFT, PIN_DC_TFT, "Adafruit2.8") ;
SPI_STMPE610 TSC(PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TSC) ;

DigitalIn pinD7(PTC9) ;

int page = 0 ;
int numPage = 5 ;

extern void doMaze(void) ;

void initTFT(void)
{
    //Configure the display driver
    TFT.BusEnable(true) ;
    TFT.FastWindow(true) ;
    TFT.background(Black);
    TFT.foreground(White);
    wait(0.01) ;
    TFT.cls();
    TFT.BusEnable(false) ;
}

void screen1(void) // Welcome Screen
{
    TFT.BusEnable(true) ;
    backlight = 0 ;
    TFT.background(White) ;
    wait(0.1) ;
    TFT.cls() ;
    wait(0.1) ;
    
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.foreground(Red) ;
    TFT.locate(80, 40) ;
    TFT.printf("MBED") ;
    TFT.foreground(Blue);
    TFT.locate(60, 80) ;
    TFT.printf("2.8\"TFT") ; 
    TFT.locate(40, 120) ;
    TFT.printf("with touch") ;
    TFT.foreground(Black);
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Blue) ;
    TFT.locate(30, 180) ;
    TFT.printf("This program is running on") ;
    TFT.locate(30, 200) ;
    TFT.printf("freescale FRDM-KL25Z with") ;
    TFT.locate(30, 220) ;
    TFT.printf("a program developed in mbed") ;
    TFT.foreground(Green) ;
    TFT.locate(30, 260) ;
    TFT.printf("To advance demo page, touch") ;
    TFT.locate(30, 280) ;
    TFT.printf("and hold right side of screen") ;
    TFT.locate(30, 300) ;
    TFT.printf("until the next screen starts") ;
    TFT.BusEnable(false) ;
    backlight = 1 ;
}

void screen2(void) // Graphics
{
    //Draw some graphics
    int i, x[2], y[2] ;
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Black);
    wait(0.1) ;
    TFT.foreground(White);
    wait(0.1) ;
    TFT.cls() ;
    wait(0.1) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(90,0);
    TFT.printf("Graphics");
    
    x[0] = 25 ; x[1] = 224 ;
    y[0] = 20 ; y[1] = 219 ;
    for (i = 20 ; i < 220 ; i += 10) {
        TFT.line(i+5, y[0], i+5, y[1], Blue) ;
        TFT.line(x[0], i, x[1], i, Blue) ;
    }
    TFT.line(125, y[0], 125, y[1], Green) ;
    TFT.line(x[0], 120, x[1], 120, Green) ;
    TFT.rect(x[0],y[0], x[1], y[1], Green) ;
    TFT.locate(10, 20) ;
    TFT.printf("V") ;
    TFT.locate(0, 115) ;
    TFT.printf("0.0") ;
    TFT.locate(115, 225) ;
    TFT.printf("0.0") ;
    TFT.locate(215, 225) ;
    TFT.printf("T") ;

    double s;
    for (int i = x[0]; i < 225; i++) {
        s = 40 * sin((long double)i / 20);
        TFT.pixel(i, 120 + (int)s, White);
    }
    
    TFT.fillrect(10, 240, 229, 309, White) ;
    TFT.rect(10, 240, 229, 309, Red) ;
    TFT.rect(11, 241, 228, 308, Red) ;
    
    TFT.background(White) ;
    TFT.foreground(Black) ;
    TFT.locate(20, 250) ;
    TFT.printf("With QVGA resolution") ;
    TFT.locate(20, 270) ;
    TFT.printf("simple graphics drawing") ;
    TFT.locate(20, 290) ;
    TFT.printf("capability is provided") ;
    TFT.BusEnable(false) ;
    backlight = 1 ;
}    

double clip(double src)
{
    double value ;
    value = src ;
    if (value < 0.0) {
        value = 0.0 ;
    } else if (value > 2.0) {
        value = 2.0 ;
    }
    return( value ) ;
}

void screen3(void)
{
    int t = 0 ;
    int pt = 0 ; // previous t 
    int i, x, y ;
    unsigned int data[3] ; // for x, y, z 
    unsigned int prev[3] ;
    unsigned short signalHeight = 39 ;
    unsigned short xoffset = 30 ;
    unsigned short yoffset = 120 ;
    unsigned short zoffset = 210 ;
    unsigned short paneX[2] = {20, 235} ;
    unsigned short paneH = 81 ;
 
    backlight = 1 ;
    TFT.BusEnable(true) ;
    TFT.background(Black) ;
    TFT.foreground(White) ;
//    TFT.cls() ;

 
    TFT.fillrect(paneX[0], xoffset, paneX[1], xoffset+paneH, Black) ;
    TFT.fillrect(paneX[0], yoffset, paneX[1], yoffset+paneH, Black) ;
    TFT.fillrect(paneX[0], zoffset, paneX[1], zoffset+paneH, Black) ;
    TFT.fillrect(paneX[0], xoffset, paneX[1], xoffset+paneH, Black) ;
    for (i = 0 ; i < 10 ; i++ ) {
        y = i * 8 ;
        TFT.line(paneX[0], xoffset + y, paneX[1], xoffset + y, Blue) ;
        TFT.line(paneX[0], yoffset + y, paneX[1], yoffset + y, Blue) ;
        TFT.line(paneX[0], zoffset + y, paneX[1], zoffset + y, Blue) ;
    }
    for (x = 30 ; x < paneX[1] ; x += 10 ) {
        TFT.line(x, xoffset, x, xoffset+paneH, Blue) ;
        TFT.line(x, yoffset, x, yoffset+paneH, Blue) ;
        TFT.line(x, zoffset, x, zoffset+paneH, Blue) ;
    } 
    TFT.rect(paneX[0], xoffset, paneX[1], xoffset+paneH, White) ;
    TFT.rect(paneX[0], yoffset, paneX[1], yoffset+paneH, White) ;
    TFT.rect(paneX[0], zoffset, paneX[1], zoffset+paneH, White) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(5, xoffset+30) ;
    TFT.printf("X") ;
    TFT.locate(5, yoffset+30) ;
    TFT.printf("Y") ;
    TFT.locate(5, zoffset+30) ;
    TFT.printf("Z") ;
    TFT.locate(50, 10) ;
    TFT.printf("Xtrinsic Accelerometer") ;
    TFT.locate(90, 300) ;
    TFT.printf("MMA8451Q") ;
    
    prev[0] = xoffset + (signalHeight * clip((1.0 + acc->getAccX()))) ;
    prev[1] = yoffset + (signalHeight * clip((1.0 + acc->getAccY()))) ;
    prev[2] = zoffset + (signalHeight * clip((1.0 + acc->getAccZ()))) ;
    pt = paneX[0] ;
    backlight = 1 ;
    for(t = 21 ; t < paneX[1] ; t++) {
        data[0] = xoffset + (signalHeight * clip((1.0 + acc->getAccX()))) ;
        data[1] = yoffset + (signalHeight * clip((1.0 + acc->getAccY()))) ;
        data[2] = zoffset + (signalHeight * clip((1.0 + acc->getAccZ()))) ;
        TFT.line(pt, prev[0], t, data[0], Red) ;
        TFT.line(pt, prev[1], t, data[1], Green) ;
        TFT.line(pt, prev[2], t, data[2], Yellow) ;
        prev[0] = data[0] ;
        prev[1] = data[1] ;
        prev[2] = data[2] ;
        pt = t ;
        wait(0.01) ;
    }
    TFT.BusEnable(false) ;
}

void screen4(void)
{
    int dx, px ;
    float delta = 0.0 ;
    dx = 0 ;
    px = 0 ;
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Black);
    wait(0.1) ;
    TFT.foreground(White);
    wait(0.1) ;
    TFT.cls() ;
    wait(0.1) ;

    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Blue) ;
    TFT.locate(60, 10) ;
    TFT.printf("<< TSI demo >>") ;
    TFT.locate(30, 280) ;
    TFT.printf("Use FRDM touch slider") ;
    TFT.locate(30, 300) ;
    TFT.printf("Touch right edge to end") ;
    
    TFT.fillcircle(120, 160, 100, Green) ;
    TFT.fillcircle(60, 160, 50, Black) ;
    TFT.fillcircle(60, 160, 45, White) ;
    TFT.fillcircle(180, 160, 50, Black) ;
    TFT.fillcircle(180, 160, 45, White) ;
    TFT.fillcircle(60, 160, 5, Black) ;
    TFT.fillcircle(180, 160, 5, Black) ;
    backlight = 1 ;

    while(dx < 38) {
      delta = (80.0 * (tsi.readPercentage()-0.5)) ;
      dx = (int)(delta + 0.5) ;
      TFT.fillcircle(60+px, 160, 5, White) ;
      TFT.fillcircle(180+px, 160, 5, White) ;
      TFT.fillcircle(60+dx, 160, 5, Black) ;
      TFT.fillcircle(180+dx, 160, 5, Black) ;
      px = dx ;
      wait(0.1) ;
    }
    TFT.fillcircle(60+px, 160, 5, White) ;
    TFT.fillcircle(180+px, 160, 5, White) ;
    TFT.line(15, 160, 105, 160, Black) ;
    TFT.line(135, 160, 225, 160, Black) ;
    TFT.foreground(Yellow) ;
    TFT.locate(30, 300) ;
//    TFT.printf("Use FRDM touch slider") ;
    TFT.printf("       Wake Up!          ") ;
    TFT.locate(5, 300) ;
    TFT.printf("<< Prev") ;
    TFT.locate(180, 300) ;
    TFT.printf("Next >>") ;
    TFT.BusEnable(false) ;
}

void incPage(void)
{
    page++ ;
    if (page >= numPage) {
        page = 0 ;
    }
}

void decPage(void) 
{
    page-- ;
    if (page < 0) {
        page = numPage - 1 ;
    }
}
    
int main()
{
    uint16_t x, y, z ;
    int prevPage = 99 ;
    bool waitTouch = false ;
    
    acc = new MMA8451Q(PTE25, PTE24, MMA8451_I2C_ADDRESS) ;
    
    initTFT() ;
    
 //   screen0() ;
        
    printf("Program Started!\n\r") ;
    
    for(;;) {
//        printf("TFT width = %d, height = %d\n\r", TFT.width(), TFT.height()) ;
        switch(page) {
        case 0:
            if (prevPage != page) {
                screen1() ;
            }
            waitTouch = true ;
            break ;
        case 1:
            if (prevPage != page) {
                screen2() ; 
            }
            waitTouch = true ;
            break ;
        case 2:
            if (prevPage != page) {
                TFT.BusEnable(true) ;
                TFT.background(Black) ;
                TFT.foreground(White) ;
                TFT.cls() ;
                TFT.BusEnable(false) ;
            }
            screen3() ; 
            waitTouch = false ;
            break ;
        case 3:
//            if (prevPage != page) {
                screen4() ;
                waitTouch = true ;
//            }
            break ;
        case 4:
//            if (prevPage != page) {
                doMaze() ;
                waitTouch = true ;
//            }
            break ;
        default:
            page = 0 ; 
            break ;
        }
        prevPage = page ;

        do {
            TSC.getRAWPoint(&x, &y, &z) ;
            if ((x != 0)||(y != 0) || (z != 0)) {
                if (x < 1000) { // left
                    decPage() ;
                } else if (x > 3000) { // right
                    incPage() ;
                }
                waitTouch = false ;
            }
        } while(waitTouch != false) ;
//        wait(1) ;
    }
}
