/* mbed main.cpp to test adafruit 2.8" TFT LCD shiled w Touchscreen
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
 /* 
  * Note: This program is derived from the SeeeStudioTFTv2 program.
  * Although both program share same ILI9341 TFT driver,
  * the touch sensor was not same with the Display I purchased from Akizuki.
  * http://akizukidenshi.com/catalog/g/gM-07747/
  * The touch sensor on the display is STMPE610,
  * so I hacked the minimum spi driver for it (polling mode only).
  */

#include "mbed.h"
#include <math.h>
#include "ILI9341.h"
#include "SPI_STMPE610.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "Arial43x48_numb.h"

#define PIN_MOSI        PA_7
#define PIN_MISO        PA_6  
#define PIN_SCLK        PA_5 
#define PIN_CS_TFT      PB_6 
#define PIN_DC_TFT      PC_7 
#define PIN_BL_TFT      PA_8 
#define PIN_CS_SD       PB_5 
#define PIN_CS_TSC      PA_9 
#define PIN_TSC_INTR    PA_8
#define PIN_RESET_TFT   PC_13 /* place holder */
#define DEVICE_NAME     "F411RE"

#ifndef TARGET_NECLEO_F411RE
#define TARGET_NECLEO_F411RE 
#endif


DigitalOut backlight(PB_3) ;
DigitalOut tsc_cs(PA_9, 1) ;
DigitalOut tft_cs(PB_6, 1) ;

ILI9341 TFT(SPI_8, 10000000, 
    PIN_MOSI, PIN_MISO,  PIN_SCLK, 
    PIN_CS_TFT, PIN_RESET_TFT, PIN_DC_TFT, "Adafruit2.8") ;
SPI_STMPE610 TSC(PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TSC) ;

int page = 0 ;
int numPage = 2 ;

void initTFT(void)
{
    //Configure the display driver
    TFT.BusEnable(true) ;
    TFT.FastWindow(true) ;
    TFT.background(Black);
    TFT.foreground(White);
    wait(0.01) ;
    TFT.cls();
    TFT.BusEnable(false) ;
}

void screen1(void) // Welcome Screen
{
    TFT.BusEnable(true) ;
    backlight = 0 ;
    TFT.background(White) ;
    wait(0.1) ;
    TFT.cls() ;
    wait(0.1) ;
    
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.foreground(Red) ;
    TFT.locate(80, 40) ;
    TFT.printf("MBED") ;
    TFT.foreground(Blue);
    TFT.locate(60, 80) ;
    TFT.printf("2.8\"TFT") ; 
    TFT.locate(40, 120) ;
    TFT.printf("with touch") ;
    TFT.foreground(Black);
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.foreground(Blue) ;
    TFT.locate(30, 180) ;
    TFT.printf("This program is running on") ;
    TFT.locate(30, 200) ;
    TFT.printf("ST Nucleo F411RE with") ;
    TFT.locate(30, 220) ;
    TFT.printf("a program developed in mbed") ;
    TFT.foreground(Green) ;
    TFT.locate(30, 260) ;
    TFT.printf("To advance demo page, touch") ;
    TFT.locate(30, 280) ;
    TFT.printf("and hold right side of screen") ;
    TFT.locate(30, 300) ;
    TFT.printf("until the next screen starts") ;
    TFT.BusEnable(false) ;
    backlight = 1 ;
}

void screen2(void) // Graphics
{
    //Draw some graphics
    int i, x[2], y[2] ;
    backlight = 0 ;
    TFT.BusEnable(true) ;
    TFT.background(Black);
    wait(0.1) ;
    TFT.foreground(White);
    wait(0.1) ;
    TFT.cls() ;
    wait(0.1) ;
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(90,0);
    TFT.printf("Graphics");
    
    x[0] = 25 ; x[1] = 224 ;
    y[0] = 20 ; y[1] = 219 ;
    for (i = 20 ; i < 220 ; i += 10) {
        TFT.line(i+5, y[0], i+5, y[1], Blue) ;
        TFT.line(x[0], i, x[1], i, Blue) ;
    }
    TFT.line(125, y[0], 125, y[1], Green) ;
    TFT.line(x[0], 120, x[1], 120, Green) ;
    TFT.rect(x[0],y[0], x[1], y[1], Green) ;
    TFT.locate(10, 20) ;
    TFT.printf("V") ;
    TFT.locate(0, 115) ;
    TFT.printf("0.0") ;
    TFT.locate(115, 225) ;
    TFT.printf("0.0") ;
    TFT.locate(215, 225) ;
    TFT.printf("T") ;

    double s;
    for (int i = x[0]; i < 225; i++) {
        s = 40 * sin((long double)i / 20);
        TFT.pixel(i, 120 + (int)s, White);
    }
    
    TFT.fillrect(10, 240, 229, 309, White) ;
    TFT.rect(10, 240, 229, 309, Red) ;
    TFT.rect(11, 241, 228, 308, Red) ;
    
    TFT.background(White) ;
    TFT.foreground(Black) ;
    TFT.locate(20, 250) ;
    TFT.printf("With QVGA resolution") ;
    TFT.locate(20, 270) ;
    TFT.printf("simple graphics drawing") ;
    TFT.locate(20, 290) ;
    TFT.printf("capability is provided") ;
    TFT.BusEnable(false) ;
    backlight = 1 ;
}    

double clip(double src)
{
    double value ;
    value = src ;
    if (value < 0.0) {
        value = 0.0 ;
    } else if (value > 2.0) {
        value = 2.0 ;
    }
    return( value ) ;
}

void incPage(void)
{
    page++ ;
    if (page >= numPage) {
        page = 0 ;
    }
}

void decPage(void) 
{
    page-- ;
    if (page < 0) {
        page = numPage - 1 ;
    }
}
    
int main()
{
    uint16_t x, y, z ;
    int prevPage = 99 ;
    bool waitTouch = false ;
    
    printf("Hello World\n") ;
    
    tsc_cs = 1 ;
    tft_cs = 0 ;
    initTFT() ;
    tft_cs = 1 ;

    tsc_cs = 0 ;
    TSC.spi_format(8, 1) ; // for Nucleo F411RE
    tsc_cs = 1 ;
    
 //   screen0() ;
        
    printf("Program Started!\n\r") ;
    
    for(;;) {
//        printf("TFT width = %d, height = %d\n\r", TFT.width(), TFT.height()) ;
        tft_cs = 0 ;
        switch(page) {
        case 0:
            if (prevPage != page) {
                screen1() ;
            }
            waitTouch = true ;
            break ;
        case 1:
            if (prevPage != page) {
                screen2() ; 
            }
            waitTouch = true ;
            break ;
        default:
            page = 0 ; 
            break ;
        }
        prevPage = page ;

        tft_cs = 1 ;
        do {
            tsc_cs = 0 ;
            TSC.getRAWPoint(&x, &y, &z) ;
            if ((x != 0)||(y != 0) || (z != 0)) {
                if (x < 1000) { // left
                    decPage() ;
                } else if (x > 3000) { // right
                    incPage() ;
                }
                waitTouch = false ;
            }
            tsc_cs = 1 ;
        } while(waitTouch != false) ;
 //       wait(1) ;
    }
}
