#ifndef _SPI_M25PE20_H_
#define _SPI_M25PE20_H_

#include "mbed.h"

/**
 * SPI_M25PE20 SPI-Flash Memory
 * 1 and 2 Mbit, Low Voltage, Page-Erasable Serial Flash Memories
 * with Byte-Alterability, 33 MHz SPI Bus, Standard Pin-out
 *
 */

class SPI_M25PE20 
{
public:
 /**
 * ST M25PE20 SPI-Flash Memory
 *
 * @param mosi SPI_MOSI pin
 * @param miso SPI_MISO pin
 * @param sclk SPI_CLK pin
 * @param cs   SPI_CS  pin
 */
 SPI_M25PE20(PinName mosi, PinName miso, PinName sclk, PinName cs) ;
 
 ~SPI_M25PE20() ;

 /*
  * some member functions here (yet to be written)
  */

 SPI m_spi;
 DigitalOut m_cs ;
 int _mode ;
 
/// write enable
  void writeEnable(void) ;
  
/// write disable
  void writeDisable(void) ;
  
/** read status register
 *
 * @returns uint8_t status register value
 */
  uint8_t readStatus(void) ;
    
/** program page
 *
 * @param int addr start address
 * @param uint8_t *data data buffer
 * @param int numData the number of data to be written
 */
  void programPage(int addr, uint8_t *data, int numData) ;
  
  // for ST M25PE20 and M25PE10
/** sector erase
 *
 * @param int addr specify the sector to be erased
 */
  void sectorErase(int addr) ;
  
/** page erase
 *
 * @param int addr specify the page to be erased
 */
  void pageErase(int addr) ;
  
  uint8_t read8(int addr) ;
  void write8(int addr, uint8_t data) ;
 
  private:
} ;
#endif // _SPI_M25PE20_H_