/*
 * SPI_M25PE20 SPI-Flash Memory
 * ST 1 and 2 Mbit, Low Voltage, Page-Erasable Serial Flash Memory
 * with Byte-Alterability, 33 MHz SPI Bus, Standard Pin-out
 */
 
#include "SPI_M25PE20.h"

#define CMD_WREN      0x06  /* Write Enable */
#define CMD_WRDI      0x04  /* Write Disable */
#define CMD_RDJDID    0x9F  /* Read Identification */
#define CMD_RDSR      0x05  /* Read Status Register */
#define CMD_READ      0x03  /* Read Data Byte */
#define CMD_FAST_READ 0x0B  /* Read Data Byte at Higher Speed */
#define CMD_PW        0x0A  /* Page Write */
#define CMD_PP        0x02  /* Page Program */
#define CMD_PE        0xDB  /* Page Erase */
#define CMD_SE        0xD8  /* Sector Erase */
#define CMD_DP        0xB9  /* Deep Power-down */
#define CMD_RDP       0xAB  /* Release from Deep Power-down */

SPI_M25PE20::SPI_M25PE20(PinName mosi, PinName miso, PinName sclk, PinName cs) :
        m_spi(mosi, miso, sclk), m_cs(cs) {
    // activate the peripheral

}

SPI_M25PE20::~SPI_M25PE20() { }

void SPI_M25PE20::writeEnable(void)
{
    m_cs = 0 ;
    m_spi.write(CMD_WREN) ;
    m_cs = 1 ;
}

void SPI_M25PE20::writeDisable(void)
{
    m_cs = 0 ;
    m_spi.write(CMD_WRDI) ;
    m_cs = 1 ;
}    

uint8_t SPI_M25PE20::readStatus(void)
{   
    uint8_t data ;
    m_cs = 0 ;
    m_spi.write(CMD_RDSR) ;
    data = m_spi.write(CMD_RDSR) ; // write data is dummy
    m_cs = 1 ;
    return( data ) ;
}

void SPI_M25PE20::programPage(int addr, uint8_t *data, int numData)
{
    int i ;
    m_cs = 0 ;
    m_spi.write(CMD_PP) ; // Program Page
    m_spi.write((addr >> 16)&0xFF) ;
    m_spi.write((addr >>  8)&0xFF) ;
    m_spi.write(addr & 0xFF) ;
    for (i = 0 ; i < numData ; i++ ) {
        m_spi.write(data[i]) ;
    }
    m_cs = 1 ;
    // you need to check RDSR WIP bit to be 0 to wait completion
}

void SPI_M25PE20::pageErase(int addr)
{
    uint8_t data[3] ;
    data[0] = (addr >> 16) & 0xFF ;
    data[1] = (addr >> 8) & 0xFF ;
    data[2] = (addr & 0xFF) ;
    m_cs = 0 ;
    m_spi.write(CMD_PE) ;
    for (int i = 0 ; i < 3 ; i++ ) {
        m_spi.write(data[i]) ;
    }
    m_cs = 1 ;
}

void SPI_M25PE20::sectorErase(int addr)
{
    uint8_t data[3] ;
    data[0] = (addr >> 16) & 0xFF ;
    data[1] = (addr >> 8) & 0xFF ;
    data[2] = (addr & 0xFF) ;
    m_cs = 0 ;
    m_spi.write(CMD_SE) ;
    for (int i = 0 ; i < 3 ; i++ ) {
        m_spi.write(data[i]) ;
    }
    m_cs = 1 ;
}

uint8_t SPI_M25PE20::read8(int addr)
{
    uint8_t data ;    
    m_cs = 0 ;
    m_spi.write(CMD_READ) ;
    m_spi.write((addr >> 16)&0xFF) ;
    m_spi.write((addr >>  8)&0xFF) ;
    m_spi.write(addr & 0xFF) ;
    data = m_spi.write(addr & 0xFF) ; // write data is dummy 
    m_cs = 1 ;
    return( data ) ;
}
