#ifndef _SPI_IS25LQ032B_H_
#define _SPI_IS25LQ032B_H_

#include "mbed.h"

/** SPI_IS25LQ032B ISSI 3V-QUAD SERIAL FLASH MEMORY MULTI-I/O SPI
 * Data Sheet: http://www.issi.com/WW/pdf/25LQ080B-016B-032B.pdf
 */

class SPI_IS25LQ032B 
{
public:
/**
 * ISSI 3V-QUAD SERIAL FLASH MEMORY MULTI-I/O SPI constructor
 *
 * @param mosi SPI_MOSI pin
 * @param miso SPI_MISO pin
 * @param sclk SPI_CLK pin
 * @param cs   SPI_CS  pin
 */
 SPI_IS25LQ032B(PinName mosi, PinName miso, PinName sclk, PinName cs) ;
 
/// Destructor
 ~SPI_IS25LQ032B() ;
 
/// write enable 
  void writeEnable(void) ;
  
/// write disable 
  void writeDisable(void) ;
 
/// read status register
  uint8_t readStatus(void) ;

/** write status register
 *
 * @param uint8_t newStatus new register value
 */
  void writeStatus(uint8_t newStatus) ;

/// read function register
  uint8_t readFunc(void) ;

/// write fucntion register
  void writeFunc(uint8_t newValue) ;

/** program page
 *
 * @param int addr start address
 * @param uint8_t *data data buffer address
 * @param int numData number of data to be written (max 256)
 */
  void programPage(int addr, uint8_t *data, int numData) ;

/// chip erase
  void chipErase(void) ;

  uint8_t read8(int addr) ;
  void write8(int addr, uint8_t data) ;
  
 SPI m_spi;
 DigitalOut m_cs ;
 int _mode ;
 
private:
} ;
#endif // _SPI_IS25LQ032B_H_