/** SPI_IS25LQ032B ISSI 3V - QUAD SERIAL FLASH MEMORY MULTI-I/O SPI
 * Data Sheet: http://www.issi.com/WW/pdf/25LQ080B-016B-032B.pdf
 *
 */
 
#include "SPI_IS25LQ032B.h"

#define CMD_RD      0x03
#define CMD_FR      0x0B
#define CMD_FRDIO   0xBB
#define CMD_FRDO    0x3B
#define CMD_FRQIO   0xEB
#define CMD_FRQO    0x6B
#define CMD_PP      0x02
#define CMD_PPQ     0x38
#define CMD_SER     0xD7
#define CMD_SER2    0x20
#define CMD_BER32   0x52
#define CMD_BER64   0xD8
#define CMD_CER     0xC7
#define CMD_WREN    0x06
#define CMD_WRDI    0x04
#define CMD_RDSR    0x05
#define CMD_WRSR    0x01
#define CMD_RDFR    0x48
#define CMD_WRFR    0x42
#define CMD_PERSUS  0x75
#define CMD_PERSUS2 0xB0
#define CMD_PERRSM  0x7A
#define CMD_PERRSM2 0x30
#define CMD_DP      0xB9
#define CMD_RDID    0xAB
#define CMD_RDPD    0xAB
#define CMD_RDUID   0x4B
#define CMD_RDJDID  0x9F
#define CMD_RDMDID  0x90
#define CMD_RDSFDP  0x5A
#define CMD_RSTEN   0x66
#define CMD_RST     0x99
#define CMD_RSTM    0xFF
#define CMD_IRP     0x62
#define CMD_IRRD    0x68

SPI_IS25LQ032B::SPI_IS25LQ032B(PinName mosi, PinName miso, PinName sclk, PinName cs) :
        m_spi(mosi, miso, sclk), m_cs(cs) {
    // activate the peripheral
}

SPI_IS25LQ032B::~SPI_IS25LQ032B() { }

void SPI_IS25LQ032B::writeEnable(void)
{
    m_cs = 0 ;
    m_spi.write(CMD_WREN) ;
    m_cs = 1 ;
}

void SPI_IS25LQ032B::writeDisable(void)
{
    m_cs = 0 ;
    m_spi.write(CMD_WRDI) ;
    m_cs = 1 ;
}    

uint8_t SPI_IS25LQ032B::readStatus(void)
{   
    uint8_t data ;
    m_cs = 0 ;
    m_spi.write(CMD_RDSR) ;
    data = m_spi.write(CMD_RDSR) ; // write data is dummy
    m_cs = 1 ;
    return( data ) ;
}

void SPI_IS25LQ032B::writeStatus(uint8_t newStatus)
{
    m_cs = 0 ;
    m_spi.write(CMD_WRSR) ;
    m_spi.write(newStatus) ;
    m_cs = 1 ;
}

uint8_t SPI_IS25LQ032B::readFunc(void) 
{
    uint8_t data ;
    m_cs = 0 ;
    m_spi.write(CMD_RDFR) ;
    data  = m_spi.write(CMD_RDFR) ;
    m_cs = 1 ;
    return(data) ;
}

void SPI_IS25LQ032B::writeFunc(uint8_t newValue) 
{
    m_cs = 0 ;
    m_spi.write(CMD_WRFR) ;
    m_spi.write(newValue) ;
    m_cs = 1 ;
}

void SPI_IS25LQ032B::programPage(int addr, uint8_t *data, int numData)
{
    int i ;
    m_cs = 0 ;
    m_spi.write(CMD_PP) ; // Program Page
    m_spi.write((addr >> 16)&0xFF) ;
    m_spi.write((addr >>  8)&0xFF) ;
    m_spi.write(addr & 0xFF) ;
    for (i = 0 ; i < numData ; i++ ) {
        m_spi.write(data[i]) ;
    }
    m_cs = 1 ;
    // you need to check RDSR WIP bit to be 0 to wait completion
}

void SPI_IS25LQ032B::chipErase(void)
{
    m_cs = 0 ;
    m_spi.write(CMD_CER) ;
    m_cs = 1 ;
}

uint8_t SPI_IS25LQ032B::read8(int addr)
{
    uint8_t data ;    
    m_cs = 0 ;
    m_spi.write(CMD_RD) ;
    m_spi.write((addr >> 16)&0xFF) ;
    m_spi.write((addr >>  8)&0xFF) ;
    m_spi.write(addr & 0xFF) ;
    data = m_spi.write(addr & 0xFF) ; // write data is dummy 
    m_cs = 1 ;
    return( data ) ;
}
