#ifndef _MAX30205_H_
#define _MAX30205_H_
/**
 * MAX30205 Human Body Temperature Sensor 
 */
#include "mbed.h"

class MAX30205
{
public:
  /**
  * MAX30205 constructor
  *
  * @param sda SDA pin
  * @param sdl SCL pin
  * @param addr addr of the I2C peripheral
  */
  MAX30205(PinName sda, PinName scl, int addr);

  /**
  * MAX30205 destructor
  */
  ~MAX30205();
  
/**
 * Get temperature
 * @param (none)
 * @returns uint16_t temperature value
 * @note bit[15] Sign
 * @note bit[14] 64 C
 * @note bit[13] 32 C
 * @note bit[12] 16 C
 * @note bit[11]  8 C
 * @note bit[10]  4 C
 * @note bit[ 9]  2 C
 * @note bit[ 8]  1 C
 * @note bit[ 7]  0.5 C
 * @note bit[ 6]  0.25 C
 * @note bit[ 5]  0.125 C
 * @note bit[ 4]  0.0625 C
 * @note bit[ 3]  0.03125 C
 * @note bit[ 2]  0.015625 C
 * @note bit[ 1]  0.0078125 C
 * @note bit[ 0]  0.00390625 C
 * @note in normal format Temp_float = (float)Temp_u16 / 256.0 ; 
 */
uint16_t getTemp(void) ;

/**
 * Get configuration register
 * @param (none)
 * @returns uint8_t configuration register value
 * @note bit[7] ONE-SHOT
 * @note bit[6] /TIMEOUT I2C but timeout 0: enable 1: disable
 * @note bit[5] DATAFORMAT 0: normal (0 - +50) 1: extended (64c + 2's comp)
 * @note bit[4] FAULT_QUEUE[1] determine the number of faults necessary to
 * @note bit[3] FAULT_QUEUE[0] trigger an OS condition.
 * @note bit[2] OS_POLARITY 0: OS output polarity active low 1: active high
 * @note bit[1] /COMPARATOR/INTERRUPT 0: comparator ode  1: interrupt mode
 * @note bit[0] SHUTDOWN 0: exit from shutdown 1: enter shutdown mode
 */
 
uint8_t  getConf(void) ;

/**
 * Set configuration register
 * @param uint8_t register value
 * @returns (none) 
 */
void     setConf(uint8_t conf) ;

/**
 * Get Thyst (lower limit threshold)
 * @param (none)
 * @returns uint16_t Thyst value
 */
uint16_t getThyst(void) ;

/**
 * Set Thyst
 * @param uint16_t thyst
 * @returns (none)
 */
void     setThyst(uint16_t thyst) ;

/**
 * Get Tos (upper limit threshold)
 * @param (none)
 * @returns uint16_t Tos
 */
uint16_t getTos(void) ;

/**
 * Set Tos
 * @param uint16_t Tos
 * @returns (none)
 */
void     setTos(uint16_t tos) ;

private:
  I2C m_i2c;
  int m_addr;
  void readRegs(int addr, uint8_t * data, int len);
  void writeRegs(uint8_t * data, int len);

};

#endif /* _MAX30205_H_ */