#include "mbed.h"
#include "MAX30205.h"

/**
 * Internal Registers
 * The device contains four registers,
 * each of which consists of 2bytes.
 * The configuration register contains only 1 byte of
 * actual data and, when read as a 2-byte register,
 * repeats the same data for the second byte.
 */
 
#define REG_TEMP  0x00
#define REG_CONF  0x01
#define REG_THYST 0x02
#define REG_TOS   0x03

MAX30205::MAX30205(PinName sda, PinName scl, int addr): m_i2c(sda, scl), m_addr(addr<<1) 
{
    // activate the peripheral
}

MAX30205::~MAX30205()
{
}

uint16_t MAX30205::getTemp(void) 
{
    uint16_t temp ;
    uint8_t data[2] ;
    readRegs(REG_TEMP, data, 2) ;
    temp = (data[0] << 8) | data[1] ;
    return(temp) ;
}

uint8_t MAX30205::getConf(void)
{
    uint8_t data[2] ;
    readRegs(REG_CONF, data, 2) ;
    return(data[0]) ;
}

void MAX30205::setConf(uint8_t conf)
{
    uint8_t data[3] ;
    data[0] = REG_CONF ;
    data[1] = conf ;
    data[2] = conf ;
    writeRegs(data, 3) ;
}

uint16_t MAX30205::getThyst(void)
{
    uint16_t thyst ;
    uint8_t data[2] ;
    readRegs(REG_THYST, data, 2) ;
    thyst = (data[0] << 8) | data[1] ;
    return(thyst) ;
}

void MAX30205::setThyst(uint16_t thyst)
{
    uint8_t data[3] ;
    data[0] = REG_THYST ;
    data[1] = (thyst >> 8) & 0xFF ;
    data[2] = thyst & 0xFF ;
    writeRegs(data, 3) ;
}

uint16_t MAX30205::getTos(void)
{
    uint16_t tos ;
    uint8_t data[2] ;
    readRegs(REG_TOS, data, 2) ;
    tos = (data[0] << 8) | data[1] ;
    return(tos) ;
}

void MAX30205::setTos(uint16_t tos)
{
    uint8_t data[3] ;
    data[0] = REG_TOS ;
    data[1] = (tos >> 8) & 0xFF ;
    data[2] = tos & 0xFF ;
    writeRegs(data, 3) ;
}

void MAX30205::readRegs(int addr, uint8_t * data, int len) {
    char t[1] = {addr};
    m_i2c.write(m_addr, t, 1, true);
    m_i2c.read(m_addr, (char *)data, len);
}

void MAX30205::writeRegs(uint8_t * data, int len) {
    m_i2c.write(m_addr, (char *)data, len);
}