#ifndef _HDC1000_H_
#define _HDC1000_H_
#include "mbed.h"
/**
 * HDC1000 Integrated Low Power Humidity and Temperature Digital Sensor 
 * I2C address: 0x40 
 */
 
#define USE_READY_PIN 1

class HDC1000 {
public:
 /**
 *  constructor
 *
 * @param sda SDA pin
 * @param scl SCL pin
 * @param rdy Ready pin
 * @param addr address of the I2C peripheral
 */
#if USE_READY_PIN
HDC1000(PinName sda, PinName scl, PinName rdy, int addr=0x40) ;
#else
HDC1000(PinName sda, PinName scl, int addr=0x40) ;
#endif
 
~HDC1000() ;

/**
 * read Temperature 
 * @param NONE
 * @returns float Temperature in Celsius degree
 */
float    readTemperature(void) ;

/**
 * read Humidity
 * @param NONE
 * @returns float Humidity in percentage
 */
float    readHumidity(void) ;

/** 
 * reset the module
 */
void     reset(void) ;

float    u2f_temp(uint16_t utemp) ;
float    u2f_hume(uint16_t uhume) ;

/* for mode 0 */
/**
 * get Raw Temperature value
 * @param NONE
 * @reurns Raw Temperature value
 */
uint16_t getTemperature(void) ;

/**
 * get Raw Humidity value
 * @param NONE
 * @returns Raw Humidity value
 */
uint16_t getHumidity(void) ;

/**
 * read Temperature and Humidity together (mode==0)
 * @param float *temp returns temperature
 * @param float *hume returns humidity
 */
void     readData(float *temp, float *hume) ;

/* for mode 1 */
void     getData(uint16_t *temp, uint16_t *hume) ;

void     setConfig(uint16_t conf) ;
uint16_t getConfig(void) ;
void     setMode(int mode) ;
int      getMode(void) ;
void     setTres(int tres) ;
int      getTres(void) ;
void     setHres(int hres) ;
int      getHres(void) ;
void     getSerialID(uint8_t data[]) ; /* returns 5 bytes ID */
uint16_t getManufactureID(void) ; /* 0x5449 : Texas Instruments */
uint16_t getDeviceID(void) ;      /* 0x1000 */

float    getTDelay(void) ;
float    getHDelay(void) ;
float    getDelay(void) ;

private:
  I2C m_i2c;
#if USE_READY_PIN
  DigitalIn m_rdy ;
#endif
  int m_addr;
  void readRegs(int addr, uint8_t * data, int len);
  void writeRegs(uint8_t * data, int len);
} ;

#endif /* _HDC1000_H_ */