/** mbed oscilloscope my implementation of a oscillo scope
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * TFTMenu.cpp
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include <ILI9341.h>
#include "SPI_STMPE610.h"
#include "Arial12x12.h"
//#include "Arial24x23.h"
#include "Arial28x28.h"
//#include "Arial43x48_numb.h"
#include "vt100.h"
#include <string.h>

#include "TFTMenu.h"

extern ILI9341 TFT ;
extern SPI_STMPE610 TSC ;
extern vt100 *tty ;


TFTMenuItem::TFTMenuItem(int x1, int y1, int x2, int y2, FuncPtr fnc, 
    char *name, uint16_t mcolor, uint16_t fcolor, int l_margin, int t_margin ) 
{
    left = x1 ;
    right = x2 ;
    top = y1 ;
    bottom = y2 ;
    if (name) {
        label = new char[strlen(name)+1] ;
        strcpy(label, name) ;
        font_color = fcolor ;
    }
    menu_color = mcolor ;
    
    left_margin = l_margin ; // 7 ; 
    top_margin = t_margin ; // 10 ; 
    func = fnc ;
}

TFTMenuItem::~TFTMenuItem() 
{
    left = 0 ;
    right = 0 ;
    top = 0 ;
    bottom = 0 ;
    if (label) {
        free(label) ;
    }
}

TFTRadioButton::TFTRadioButton(int x1, int y1, int x2, int y2, FuncPtr fnc, 
    char *name, uint16_t mcolor, uint16_t fcolor,
    char *altname, uint16_t altmcolor, uint16_t altfcolor, 
    bool sel) : TFTMenuItem(x1,y1,x2,y2,fnc,name,mcolor,fcolor)
{
    if (altname) {
        alt_label = new char[strlen(altname) + 1] ;
        strcpy(alt_label, altname) ;
    } else {
        alt_label = 0 ;
    }
    alt_font_color = altfcolor ;
    alt_menu_color = altmcolor ;
    selected = sel ;
}

TFTRadioButton::~TFTRadioButton() 
{
    left = 0 ;
    right = 0 ;
    top = 0 ;
    bottom = 0 ;
    if (label) {
        delete label ;
    }
    if (alt_label) {
        delete alt_label ;
    }
}

bool TFTRadioButton::hit(int x, int y)
{
    bool result = false ;
    if ((left <= x)&&(x <= right)&&(top <= y)&&(y <= bottom)) {
        result = true ;
        if (selected) {
            selected = false ;
        } else {
            selected = true ;
        }
        draw() ;
    }
    return( result ) ;
}

void TFTRadioButton::select(bool value)
{
    selected = value ;
}

uint16_t TFTMenuItem::getColor(void) 
{
    return(menu_color) ;
}

bool TFTMenuItem::hit(int x, int y) 
{
    bool result = false ;
    if ((left <= x)&&(x <= right)&&(top <= y)&&(y <= bottom)) {
        result = true ;
        draw() ;
    }
//    draw() ;
    return( result ) ;
}

void TFTMenuItem::doIt(void)
{
    if (func) {
        func() ;
    }
}

void TFTMenuItem::font_margin(int x, int y) 
{
    top_margin = y ;
    left_margin = x ;
}

void TFTMenuItem::draw(int offset_x, int offset_y)
{
    TFT.BusEnable(true) ;
    TFT.fillrect(left+offset_x, top+offset_y, right+offset_x, bottom+offset_y, Black) ;
    TFT.fillrect(left+offset_x, top+offset_y, right+offset_x, bottom+offset_y, menu_color) ;
    wait(0.1) ;
    TFT.locate(left+offset_x+left_margin, top+offset_y+top_margin) ;
    TFT.foreground(font_color) ;
    TFT.background(menu_color) ;
    TFT.set_font((unsigned char *)Arial28x28) ;
    wait(0.1) ;
    TFT.printf(label) ;
    TFT.BusEnable(false) ;
}

void TFTRadioButton::draw(int offset_x, int offset_y)
{
    TFT.BusEnable(true) ;
    if (selected) {
        TFT.fillrect(left+offset_x, top+offset_y, right+offset_x, bottom+offset_y, Black) ;
        TFT.fillrect(left+offset_x, top+offset_y, right+offset_x, bottom+offset_y, alt_menu_color) ;
        wait(0.1) ;
        TFT.locate(left+offset_x+left_margin, top+offset_y+top_margin) ;
        TFT.foreground(alt_font_color) ;
        TFT.background(alt_menu_color) ;
        TFT.set_font((unsigned char *)Arial12x12) ;
        wait(0.1) ;
        TFT.printf(alt_label) ;
    } else {
        TFTMenuItem::draw(offset_x, offset_y) ;
    }
    TFT.BusEnable(false) ;
}
        

void TFTMenuItem::highlight(int offset_x, int offset_y)
{
    TFT.BusEnable(true) ;
    TFT.rect(left+offset_x, top+offset_y, right+offset_x, bottom+offset_y, font_color) ;
    TFT.BusEnable(false) ;
}