/** mbed oscilloscope my implementation of a oscillo scope
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * menu.cpp
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include <ILI9341.h>
#include "SPI_STMPE610.h"
//#include "Arial12x12.h"
//#include "Arial24x23.h"
#include "Arial28x28.h"
//#include "Arial43x48_numb.h"
#include "vt100.h"
#include "TFTMenu.h"
#include "menu.h"
#include "main.h"

#define NUM_MAX_DIGIT 8
int num_digit = 0 ;
long prevValue = 0 ;
long topValue = 0 ;
int op = opPlus ;

void doDigit(int num)
{
    if (num_digit < NUM_MAX_DIGIT) {
        topValue = topValue * 10 + num ;
        num_digit++ ;
        display() ;
    }
}

void do0(void) { doDigit(0) ; }
void do1(void) { doDigit(1) ; }
void do2(void) { doDigit(2) ; }
void do3(void) { doDigit(3) ; }
void do4(void) { doDigit(4) ; }
void do5(void) { doDigit(5) ; }
void do6(void) { doDigit(6) ; }
void do7(void) { doDigit(7) ; }
void do8(void) { doDigit(8) ; }
void do9(void) { doDigit(9) ; }

void doPlus(void) 
{
    doCalc() ;
    prevValue = topValue ;
    topValue = 0 ;
    num_digit = 0 ;
    op = opPlus ;
    display("+") ;
}

void doMinus(void) 
{
    doCalc() ;
    prevValue = topValue ;
    topValue = 0 ;
    num_digit = 0 ;
    op = opMinus ;
    display("-") ;
}

void doMul(void) 
{
    doCalc() ;
    prevValue = topValue ;
    topValue = 0 ;
    num_digit = 0 ;
    op = opMul ;
    display("x") ;
}

void doDiv(void) 
{
    doCalc() ;
    prevValue = topValue ;
    topValue = 0 ;
    num_digit = 0 ;
    op = opDiv ;
    display("/") ;
}

void doClear(void) 
{
    prevValue = 0 ;
    topValue = 0 ;
    num_digit = 0 ;
    op = opPlus ;
    display() ;
}

int doCalc(void)
{
    int error = 0 ;
    switch(op) {
    case opPlus:
        topValue += prevValue ;
        break ;
    case opMinus:
        topValue = prevValue - topValue ;
        break ;
    case opMul:
        topValue = prevValue * topValue ;
        break ;
    case opDiv:
        if (topValue != 0) {
            topValue = prevValue / topValue ;
        } else {
            error = 1 ;
        }
        break ;
    default:
        break ;
    }
    prevValue = 0 ;
    return(error) ;
}

void doEqu(void) 
{
    int error = 0 ;
    error = doCalc() ;
    if (error) {
        display("Error!") ;
    } else {
        display() ;
    }
    op = opPlus ;
    num_digit = 0 ;
}

void initMenu(void)
{
    int f_left = 18 ;
    int f_top = 14 ;
    
    numMenu = 0 ;
    menu[numMenu++] = new TFTMenuItem(  5, 85,  55, 135, do7,     "7", Green, Black, f_left, f_top) ;
    menu[numMenu++] = new TFTMenuItem( 65, 85, 115, 135, do8,     "8", Green, Black, f_left, f_top) ;
    menu[numMenu++] = new TFTMenuItem(125, 85, 175, 135, do9,     "9", Green, Black, f_left, f_top) ;
    menu[numMenu++] = new TFTMenuItem(185, 85, 235, 135, doClear, "C", Green, Black, f_left, f_top) ;
    
    menu[numMenu++] = new TFTMenuItem(  5, 145,  55, 195, do4,    "4", Green, Black, f_left, f_top) ;
    menu[numMenu++] = new TFTMenuItem( 65, 145, 115, 195, do5,    "5", Green, Black, f_left, f_top) ;
    menu[numMenu++] = new TFTMenuItem(125, 145, 175, 195, do6,    "6", Green, Black, f_left, f_top) ;
    menu[numMenu++] = new TFTMenuItem(185, 145, 235, 195, doMinus,"-", Green, Black, f_left, f_top) ;
    
    menu[numMenu++] = new TFTMenuItem(  5, 205,  55, 255, do1,    "1", Green, Black, f_left, f_top) ;
    menu[numMenu++] = new TFTMenuItem( 65, 205, 115, 255, do2,    "2", Green, Black, f_left, f_top) ;
    menu[numMenu++] = new TFTMenuItem(125, 205, 175, 255, do3,    "3", Green, Black, f_left, f_top) ;
    menu[numMenu++] = new TFTMenuItem(185, 205, 235, 255, doPlus, "+", Green, Black, f_left, f_top) ;
    
    menu[numMenu++] = new TFTMenuItem(  5, 265,  55, 315, do0,    "0", Green, Black, f_left, f_top) ;
    menu[numMenu++] = new TFTMenuItem( 65, 265, 115, 315, doMul  ,"x", Green, Black, f_left, f_top) ;
    menu[numMenu++] = new TFTMenuItem(125, 265, 175, 315, doDiv,  "/", Green, Black, f_left, f_top) ;
    menu[numMenu++] = new TFTMenuItem(185, 265, 235, 315, doEqu,  "=", Green, Black, f_left, f_top) ;
}

void drawMenu(void)
{
    for (int i = 0 ; i < numMenu ; i++ ) {
        menu[i]->draw() ;
    }
}

bool doMenu(uint16_t x, uint16_t y)
{
    bool result = false ;

    for (int i = 0 ; i < numMenu ; i++ ) {
        if (menu[i]->hit(x, y)) {
            menu[i]->doIt() ;
            menu[i]->draw() ;
            result = true ;
 //           printf("%s TopValue = %d, PreValue = %d\n\r", menu[i]->name(), topValue, prevValue) ;
            break ;
        }
    }
    return( result ) ;
}