/** mbed oscilloscope my implementation of a oscillo scope
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include <string.h>
#include <ILI9341.h>
//#include "Arial12x12.h"
//#include "Arial24x23.h"
#include "Arial28x28.h"
//#include "Arial43x48_numb.h"
#include "SPI_STMPE610.h"
#include "vt100.h"
#include "TFTMenu.h"
#include "menu.h"
#include "main.h"

#if defined (TARGET_MAX32600MBED)
vt100 tty(57600) ;
#else
vt100 tty ;
#endif 

DigitalOut tsc_cs(PIN_CS_TSC, 1) ;
DigitalOut backlight(PIN_BL_TFT, 0) ;
ILI9341 TFT(SPI_8, 10000000, 
    PIN_MOSI, PIN_MISO,  PIN_SCLK, 
    PIN_CS_TFT, PIN_RESET_TFT, PIN_DC_TFT, "Adafruit2.8") ;
SPI_STMPE610 TSC(PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TSC) ;
TFTMenuItem *menu[NUM_MAX_MENU] ;
int numMenu = 0 ;

void initTFT(void)
{
    //Configure the display driver
    TFT.BusEnable(true) ;
    TFT.FastWindow(true) ;
    TFT.background(Black);
    TFT.foreground(White);
    wait(0.01) ;
    TFT.cls();
    TFT.set_orientation(0) ;
    wait(0.1) ;
    TFT.BusEnable(false) ;
}

void hello()
{
    printf("=== simple calculator ===\n\r") ;
    printf("built: %s\n\r",__DATE__) ;
}

void display(char *label)
{
    char str[16] ;
    int dummy ;
    int x = 200 ;
    int y = 30 ;
    int font_width = 16 ;
    dummy = topValue ;

    TFT.BusEnable(true) ;
    TFT.fillrect(0, 0, 239, 80, Black) ;
    wait(0.1) ;
    TFT.foreground(White) ;
    TFT.background(Black) ;
    wait(0.01) ;
    TFT.set_font((unsigned char *)Arial28x28) ;
    wait(0.1) ;
    
    if ((label != 0)&&(*label != 0)) {
        strcpy(str, label) ;
    } else {
        sprintf(str, "%d", dummy) ;
    }
    x = 228 - (strlen(str) * font_width) ;
    TFT.locate(x, y) ;
    TFT.printf(str) ;
    TFT.BusEnable(false) ;
}

int main() 
{
    int touched ;
    uint16_t x, y ;
    bool result ;
    tsc_cs = 1 ; 

    backlight = 0 ;
    initTFT() ;
    initMenu() ;    
    drawMenu() ;
    backlight = 1 ;
    hello() ;
    
    display() ;
    
    while(1) {
//       tsc_cs = 0 ;
        touched = TSC.getPoint(&x, &y) ;
//        tsc_cs = 1 ;
//        if (touched && ((x != 0)||(y != 0))) { // TSC sometimes returns (0,0)
        if ((x != 0)||(y !=0)) { // FRDM-KL46Z fails to return touched somehow
            result = doMenu(x, y) ;
        }
        wait(0.01) ;
    }
}
