/** mbed oscilloscope my implementation of a oscillo scope
 * Copyright (c) 2014, 2015 Motoo Tanaka @ Design Methodology Lab
 *
 * TFTMenu.h
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef _TFT_MENU_H_
#define _TFT_MENU_H_ defined

typedef void (*FuncPtr)(void) ;

class TFTMenuItem {
public:
TFTMenuItem(int x1, int y1, int x2, int y2, FuncPtr fnc, 
    char *name, uint16_t mc, uint16_t fc,
    int l_margin = 7, int t_margin = 10) ;
~TFTMenuItem() ;
virtual bool hit(int x, int y) ;
virtual void draw(int offset_x = 0, int offset_y = 0) ;
virtual void font_margin(int x, int y) ;
void highlight(int offset_x = 0, int offset_y = 0) ;
uint16_t getColor(void) ;
void doIt(void) ;
const char *name(void) { return label ; }

protected:
char *label ;
uint16_t font_color ;
uint16_t menu_color ;
int top ; 
int bottom ;
int left ;
int right ;
int left_margin ;
int top_margin ;
FuncPtr func ;
private:
} ;

class TFTRadioButton : public TFTMenuItem {
public:
TFTRadioButton(int x1, int y1, int x2, int y2, FuncPtr fnc, 
    char *name, uint16_t mc, uint16_t fc,
    char *altname = 0, uint16_t altmc = 0, uint16_t altfc = 0, 
    bool sel = false) ;
~TFTRadioButton() ;

virtual bool hit(int x, int y) ;
virtual void draw(int offset_x = 0, int offset_y = 0) ;

void select(bool value) ;

protected:
bool selected ;
char *alt_label ;
uint16_t alt_font_color ;
uint16_t alt_menu_color ;
// FuncPtr alt_func ;
private:
} ;

class TFTMenu {
public:
TFTMenu() ; // constructor
~TFTMenu() ; // destructor 
private:
} ;

#endif /* _TFT_MENU_H_ */